/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.Member;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.semantic.v2.TypeBuilder;

public class ClassTypeBuilder
implements TypeBuilder<ClassType> {
    private final String name;
    private final String fullyQualifiedName;
    Set<Member> members = new HashSet<Member>();
    List<PythonType> attributes = new ArrayList<PythonType>();
    List<TypeWrapper> superClasses = new ArrayList<TypeWrapper>();
    List<PythonType> metaClasses = new ArrayList<PythonType>();
    boolean hasDecorators = false;
    boolean isGeneric = false;
    LocationInFile definitionLocation;

    @Override
    public ClassType build() {
        return new ClassType(this.name, this.fullyQualifiedName, this.members, this.attributes, this.superClasses, this.metaClasses, this.hasDecorators, this.isGeneric, this.definitionLocation);
    }

    public ClassTypeBuilder(String name, String fullyQualifiedName) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public ClassTypeBuilder withHasDecorators(boolean hasDecorators) {
        this.hasDecorators = hasDecorators;
        return this;
    }

    public ClassTypeBuilder withIsGeneric(boolean isGeneric) {
        this.isGeneric = isGeneric;
        return this;
    }

    public ClassTypeBuilder withDefinitionLocation(@Nullable LocationInFile definitionLocation) {
        this.definitionLocation = definitionLocation;
        return this;
    }

    public ClassTypeBuilder addSuperClass(PythonType type) {
        this.superClasses.add(TypeWrapper.of(type));
        return this;
    }

    public ClassTypeBuilder addSuperClass(TypeWrapper typeWrapper) {
        this.superClasses.add(typeWrapper);
        return this;
    }

    public ClassTypeBuilder withSuperClasses(PythonType ... types) {
        Arrays.stream(types).forEach(this::addSuperClass);
        return this;
    }

    public List<PythonType> metaClasses() {
        return this.metaClasses;
    }
}

