/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CapturePattern;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.FunctionLike;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.TypeAliasStatement;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.Scope;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.ClassDefImpl;
import org.sonar.python.tree.ComprehensionExpressionImpl;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.FileInputImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.ImportFromImpl;
import org.sonar.python.tree.LambdaExpressionImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeInference;
import org.sonar.python.types.TypeShed;

public class SymbolTableBuilder
extends BaseTreeVisitor {
    private final String fullyQualifiedModuleName;
    private final List<String> filePath;
    private final ProjectLevelSymbolTable projectLevelSymbolTable;
    private Map<Tree, Scope> scopesByRootTree;
    private FileInput fileInput = null;
    private final Set<Tree> assignmentLeftHandSides = new HashSet<Tree>();
    private final PythonFile pythonFile;
    private final Set<String> importedModulesFQN = new HashSet<String>();

    public SymbolTableBuilder(PythonFile pythonFile) {
        this.fullyQualifiedModuleName = null;
        this.filePath = null;
        this.projectLevelSymbolTable = ProjectLevelSymbolTable.empty();
        this.pythonFile = pythonFile;
    }

    public Set<String> importedModulesFQN() {
        return Collections.unmodifiableSet(this.importedModulesFQN);
    }

    public SymbolTableBuilder(String packageName, PythonFile pythonFile) {
        this(packageName, pythonFile, ProjectLevelSymbolTable.empty());
    }

    public SymbolTableBuilder(String packageName, PythonFile pythonFile, ProjectLevelSymbolTable projectLevelSymbolTable) {
        this.pythonFile = pythonFile;
        String fileName = pythonFile.fileName();
        this.fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, fileName);
        this.filePath = new ArrayList<String>(Arrays.asList(this.fullyQualifiedModuleName.split("\\.")));
        if ("__init__".equals(SymbolUtils.getModuleFileName(fileName))) {
            this.filePath.add("");
        }
        this.projectLevelSymbolTable = projectLevelSymbolTable;
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.fileInput = fileInput;
        this.scopesByRootTree = new HashMap<Tree, Scope>();
        fileInput.accept(new FirstPhaseVisitor());
        fileInput.accept(new SecondPhaseVisitor());
        this.createAmbiguousSymbols();
        this.addSymbolsToTree((FileInputImpl)fileInput);
        fileInput.accept(new ThirdPhaseVisitor());
        TypeInference.inferTypes(fileInput, this.pythonFile);
    }

    private void createAmbiguousSymbols() {
        for (Scope scope : this.scopesByRootTree.values()) {
            HashSet<SymbolToUpdate> symbolsToUpdate = new HashSet<SymbolToUpdate>();
            for (Symbol symbol : scope.symbols()) {
                List<Usage> bindingUsages;
                if (symbol.kind() != Symbol.Kind.OTHER || (bindingUsages = symbol.usages().stream().filter(Usage::isBindingUsage).toList()).size() <= 1 || !bindingUsages.stream().anyMatch(usage -> usage.kind() == Usage.Kind.FUNC_DECLARATION || usage.kind() == Usage.Kind.CLASS_DECLARATION)) continue;
                Set<Symbol> alternativeDefinitions = this.createAlternativeDefinitions(symbol, bindingUsages);
                AmbiguousSymbol ambiguousSymbol = AmbiguousSymbolImpl.create(alternativeDefinitions);
                symbol.usages().forEach(usage -> ((SymbolImpl)((Object)ambiguousSymbol)).addUsage(usage.tree(), usage.kind()));
                symbolsToUpdate.add(new SymbolToUpdate(symbol, ambiguousSymbol));
            }
            symbolsToUpdate.forEach(symbolToUpdate -> scope.replaceSymbolWithAmbiguousSymbol(symbolToUpdate.symbol, symbolToUpdate.ambiguousSymbol));
        }
    }

    private Set<Symbol> createAlternativeDefinitions(Symbol symbol, List<Usage> bindingUsages) {
        HashSet<Symbol> alternativeDefinitions = new HashSet<Symbol>();
        block4: for (Usage bindingUsage : bindingUsages) {
            switch (bindingUsage.kind()) {
                case FUNC_DECLARATION: {
                    FunctionDef functionDef = (FunctionDef)bindingUsage.tree().parent();
                    FunctionSymbolImpl functionSymbol = new FunctionSymbolImpl(functionDef, symbol.fullyQualifiedName(), this.pythonFile);
                    ((FunctionDefImpl)functionDef).setFunctionSymbol(functionSymbol);
                    alternativeDefinitions.add(functionSymbol);
                    continue block4;
                }
                case CLASS_DECLARATION: {
                    ClassDef classDef = (ClassDef)bindingUsage.tree().parent();
                    ClassSymbolImpl classSymbol = new ClassSymbolImpl(classDef, symbol.fullyQualifiedName(), this.pythonFile);
                    SymbolUtils.resolveTypeHierarchy(classDef, classSymbol, this.pythonFile, this.scopesByRootTree.get((Object)this.fileInput).symbolsByName);
                    Scope classScope = this.scopesByRootTree.get(classDef);
                    classSymbol.addMembers(SymbolTableBuilder.getClassMembers(classScope.symbolsByName, classScope.instanceAttributesByName));
                    alternativeDefinitions.add(classSymbol);
                    continue block4;
                }
            }
            SymbolImpl alternativeSymbol = new SymbolImpl(symbol.name(), symbol.fullyQualifiedName());
            alternativeDefinitions.add(alternativeSymbol);
        }
        return alternativeDefinitions;
    }

    private void addSymbolsToTree(FileInputImpl fileInput) {
        for (Scope scope : this.scopesByRootTree.values()) {
            Tree tree = scope.rootTree;
            if (tree instanceof FunctionLike) {
                FunctionLike funcDef = (FunctionLike)tree;
                for (Symbol symbol2 : scope.symbols()) {
                    if (funcDef.is(Tree.Kind.LAMBDA)) {
                        ((LambdaExpressionImpl)funcDef).addLocalVariableSymbol(symbol2);
                        continue;
                    }
                    ((FunctionDefImpl)funcDef).addLocalVariableSymbol(symbol2);
                }
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.CLASSDEF)) {
                ClassDefImpl classDef = (ClassDefImpl)scope.rootTree;
                scope.symbols().forEach(classDef::addClassField);
                scope.instanceAttributesByName.values().forEach(classDef::addInstanceField);
                Symbol classSymbol = classDef.name().symbol();
                Optional.ofNullable(classSymbol).filter(symbol -> symbol.kind() == Symbol.Kind.CLASS).map(ClassSymbolImpl.class::cast).ifPresent(symbol -> symbol.addMembers(SymbolTableBuilder.getClassMembers(scope.symbolsByName, scope.instanceAttributesByName)));
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.FILE_INPUT)) {
                scope.symbols().stream().filter(s -> !scope.builtinSymbols.contains(s)).forEach(fileInput::addGlobalVariables);
                continue;
            }
            if (scope.rootTree.is(Tree.Kind.DICT_COMPREHENSION)) {
                scope.symbols().forEach(((DictCompExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
                continue;
            }
            if (!(scope.rootTree instanceof ComprehensionExpression)) continue;
            scope.symbols().forEach(((ComprehensionExpressionImpl)scope.rootTree)::addLocalVariableSymbol);
        }
    }

    private static Set<Symbol> getClassMembers(Map<String, Symbol> symbolsInClass, Map<String, SymbolImpl> instanceAttributesByName) {
        HashSet<Symbol> members = new HashSet<Symbol>(symbolsInClass.values());
        for (SymbolImpl instanceAttribute : instanceAttributesByName.values()) {
            SymbolImpl member = (SymbolImpl)symbolsInClass.get(instanceAttribute.name());
            if (member != null) {
                for (Usage usage : instanceAttribute.usages()) {
                    if (usage.isBindingUsage()) {
                        member.setKind(Symbol.Kind.OTHER);
                    }
                    member.addUsage(usage.tree(), usage.kind());
                }
                continue;
            }
            members.add(instanceAttribute);
        }
        return members;
    }

    private class FirstPhaseVisitor
    extends ScopeVisitor {
        private FirstPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.createScope(tree, null);
            this.enterScope(tree);
            this.moduleScope = this.currentScope();
            Map<String, Symbol> typeShedSymbols = TypeShed.builtinSymbols();
            for (String name : BuiltinSymbols.all()) {
                this.currentScope().createBuiltinSymbol(name, typeShedSymbols);
            }
            super.visitFileInput(tree);
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.createScope(pyLambdaExpressionTree, this.currentScope());
            this.enterScope(pyLambdaExpressionTree);
            this.createParameters(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpression tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitDictCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitDecorator(Decorator tree) {
            this.leaveScope();
            super.visitDecorator(tree);
            this.enterScope(tree.parent());
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.createScope(tree, this.currentScope());
            this.enterScope(tree);
            super.visitPyListOrSetCompExpression(tree);
            this.leaveScope();
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            String functionName = pyFunctionDefTree.name().name();
            String fullyQualifiedName = this.getFullyQualifiedName(functionName);
            this.currentScope().addFunctionSymbol(pyFunctionDefTree, fullyQualifiedName);
            this.createScope(pyFunctionDefTree, this.currentScope());
            this.enterScope(pyFunctionDefTree);
            this.createTypeParameters(pyFunctionDefTree.typeParams());
            this.createParameters(pyFunctionDefTree);
            super.visitFunctionDef(pyFunctionDefTree);
            this.leaveScope();
        }

        private void createTypeParameters(@Nullable TypeParams typeParams) {
            Optional.ofNullable(typeParams).map(TypeParams::typeParamsList).stream().flatMap(Collection::stream).forEach(typeParam -> this.addBindingUsage(typeParam.name(), Usage.Kind.TYPE_PARAM_DECLARATION));
        }

        @Override
        public void visitTypeAliasStatement(TypeAliasStatement typeAliasStatement) {
            this.addBindingUsage(typeAliasStatement.name(), Usage.Kind.TYPE_ALIAS_DECLARATION);
            super.visitTypeAliasStatement(typeAliasStatement);
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            String className = pyClassDefTree.name().name();
            String fullyQualifiedName = this.getFullyQualifiedName(className);
            this.currentScope().addClassSymbol(pyClassDefTree, fullyQualifiedName);
            this.createScope(pyClassDefTree, this.currentScope());
            this.enterScope(pyClassDefTree);
            this.createTypeParameters(pyClassDefTree.typeParams());
            super.visitClassDef(pyClassDefTree);
            this.leaveScope();
        }

        @CheckForNull
        private String getFullyQualifiedName(String name) {
            String prefix = this.scopeQualifiedName();
            if (prefix != null) {
                return prefix.isEmpty() ? name : prefix + "." + name;
            }
            return null;
        }

        private String scopeQualifiedName() {
            Tree scopeTree = this.currentScopeRootTree();
            if (scopeTree.is(Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF)) {
                Name name = scopeTree.is(Tree.Kind.CLASSDEF) ? ((ClassDef)scopeTree).name() : ((FunctionDef)scopeTree).name();
                return Optional.ofNullable(name.symbol()).map(Symbol::fullyQualifiedName).orElse(name.name());
            }
            return SymbolTableBuilder.this.fullyQualifiedModuleName;
        }

        @Override
        public void visitImportName(ImportName pyImportNameTree) {
            this.createImportedNames(pyImportNameTree.modules(), null, Collections.emptyList());
            super.visitImportName(pyImportNameTree);
        }

        @Override
        public void visitImportFrom(ImportFrom importFrom) {
            String moduleName;
            DottedName moduleTree = importFrom.module();
            String string = moduleName = moduleTree != null ? moduleTree.names().stream().map(Name::name).collect(Collectors.joining(".")) : null;
            if (importFrom.isWildcardImport()) {
                SymbolTableBuilder.this.importedModulesFQN.add(moduleName);
                Set<Symbol> importedModuleSymbols = SymbolTableBuilder.this.projectLevelSymbolTable.getSymbolsFromModule(moduleName);
                if (importedModuleSymbols == null && moduleName != null && !moduleName.equals(SymbolTableBuilder.this.fullyQualifiedModuleName)) {
                    importedModuleSymbols = TypeShed.symbolsForModule(moduleName).values().stream().map(importedSymbol -> this.currentScope().copySymbol(importedSymbol.name(), (Symbol)importedSymbol)).collect(Collectors.toSet());
                }
                if (importedModuleSymbols != null && !importedModuleSymbols.isEmpty()) {
                    this.currentScope().createSymbolsFromWildcardImport(importedModuleSymbols, importFrom);
                    ((ImportFromImpl)importFrom).setHasUnresolvedWildcardImport(false);
                } else {
                    ((ImportFromImpl)importFrom).setHasUnresolvedWildcardImport(true);
                }
            } else {
                this.createImportedNames(importFrom.importedNames(), moduleName, importFrom.dottedPrefixForModule());
            }
            super.visitImportFrom(importFrom);
        }

        private void createImportedNames(List<AliasedName> importedNames, @Nullable String fromModuleName, List<Token> dottedPrefix) {
            importedNames.forEach(module -> {
                String fullyQualifiedName;
                List<Name> dottedNames = module.dottedName().names();
                Name nameTree = dottedNames.get(0);
                String targetModuleName = fromModuleName;
                String string = fullyQualifiedName = targetModuleName != null ? targetModuleName + "." + nameTree.name() : nameTree.name();
                if (!dottedPrefix.isEmpty()) {
                    fullyQualifiedName = this.resolveFullyQualifiedNameBasedOnRelativeImport(dottedPrefix, fullyQualifiedName);
                    targetModuleName = this.resolveFullyQualifiedNameBasedOnRelativeImport(dottedPrefix, targetModuleName);
                } else {
                    SymbolTableBuilder.this.importedModulesFQN.add(fullyQualifiedName);
                }
                Name alias = module.alias();
                if (targetModuleName != null) {
                    this.currentScope().addImportedSymbol(alias == null ? nameTree : alias, fullyQualifiedName, targetModuleName);
                } else if (alias != null) {
                    String fullName = dottedNames.stream().map(Name::name).collect(Collectors.joining("."));
                    this.currentScope().addModuleSymbol(alias, fullName);
                } else if (dottedPrefix.isEmpty() && dottedNames.size() > 1) {
                    dottedNames.stream().map(Name::name).reduce((a, b) -> String.join((CharSequence)".", a, b)).ifPresent(fqn -> this.currentScope().addSubmoduleSymbol(nameTree, (String)fqn));
                } else {
                    this.currentScope().addModuleSymbol(nameTree, fullyQualifiedName);
                }
            });
        }

        @CheckForNull
        private String resolveFullyQualifiedNameBasedOnRelativeImport(List<Token> dottedPrefix, @Nullable String moduleName) {
            if (SymbolTableBuilder.this.filePath == null || dottedPrefix.size() > SymbolTableBuilder.this.filePath.size()) {
                return null;
            }
            String resolvedPackageName = String.join((CharSequence)".", SymbolTableBuilder.this.filePath.subList(0, SymbolTableBuilder.this.filePath.size() - dottedPrefix.size()));
            if (moduleName == null) {
                SymbolTableBuilder.this.importedModulesFQN.add(resolvedPackageName);
                return resolvedPackageName;
            }
            if (resolvedPackageName.isEmpty()) {
                SymbolTableBuilder.this.importedModulesFQN.add(moduleName);
                return moduleName;
            }
            String resolvedModuleFQN = resolvedPackageName + "." + moduleName;
            SymbolTableBuilder.this.importedModulesFQN.add(resolvedModuleFQN);
            return resolvedModuleFQN;
        }

        @Override
        public void visitForStatement(ForStatement pyForStatementTree) {
            this.createLoopVariables(pyForStatementTree);
            super.visitForStatement(pyForStatementTree);
        }

        @Override
        public void visitComprehensionFor(ComprehensionFor tree) {
            this.addCompDeclarationParam(tree.loopExpression());
            super.visitComprehensionFor(tree);
        }

        private void addCompDeclarationParam(Tree tree) {
            SymbolUtils.boundNamesFromExpression(tree).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.COMP_DECLARATION));
        }

        private void createLoopVariables(ForStatement loopTree) {
            loopTree.expressions().forEach(expr -> SymbolUtils.boundNamesFromExpression(expr).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.LOOP_DECLARATION)));
        }

        private void createParameters(FunctionLike function) {
            AnyParameter first;
            ParameterList parameterList = function.parameters();
            if (parameterList == null || parameterList.all().isEmpty()) {
                return;
            }
            boolean hasSelf = false;
            if (function.isMethodDefinition() && (first = parameterList.all().get(0)).is(Tree.Kind.PARAMETER)) {
                this.currentScope().createSelfParameter((Parameter)first);
                hasSelf = true;
            }
            parameterList.nonTuple().stream().skip(hasSelf ? 1L : 0L).map(Parameter::name).filter(Objects::nonNull).forEach(param -> this.addBindingUsage((Name)param, Usage.Kind.PARAMETER));
            parameterList.all().stream().filter(param -> param.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        private void addTupleParamElementsToBindingUsage(TupleParameter param) {
            param.parameters().stream().filter(p -> p.is(Tree.Kind.PARAMETER)).map(p -> ((Parameter)p).name()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.PARAMETER));
            param.parameters().stream().filter(p -> p.is(Tree.Kind.TUPLE_PARAMETER)).map(TupleParameter.class::cast).forEach(this::addTupleParamElementsToBindingUsage);
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
            List<Expression> lhs = SymbolUtils.assignmentsLhs(pyAssignmentStatementTree);
            SymbolTableBuilder.this.assignmentLeftHandSides.addAll(lhs);
            lhs.forEach(expression -> SymbolUtils.boundNamesFromExpression(expression).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.ASSIGNMENT_LHS)));
            super.visitAssignmentStatement(pyAssignmentStatementTree);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                Name variable = (Name)annotatedAssignment.variable();
                this.addBindingUsage(variable, Usage.Kind.ASSIGNMENT_LHS, this.getFullyQualifiedName(variable.name()));
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        @Override
        public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
            if (pyCompoundAssignmentStatementTree.lhsExpression().is(Tree.Kind.NAME)) {
                this.addBindingUsage((Name)pyCompoundAssignmentStatementTree.lhsExpression(), Usage.Kind.COMPOUND_ASSIGNMENT_LHS);
            }
            super.visitCompoundAssignment(pyCompoundAssignmentStatementTree);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
            Scope scope = this.currentScope();
            Tree scopeRootTree = scope.rootTree;
            if (scopeRootTree.is(Tree.Kind.GENERATOR_EXPR) || scopeRootTree instanceof ComprehensionExpression || scopeRootTree instanceof DictCompExpression) {
                scope.parent().addBindingUsage(assignmentExpression.lhsName(), Usage.Kind.ASSIGNMENT_LHS, null);
            } else {
                this.addBindingUsage(assignmentExpression.lhsName(), Usage.Kind.ASSIGNMENT_LHS);
            }
            super.visitAssignmentExpression(assignmentExpression);
        }

        @Override
        public void visitGlobalStatement(GlobalStatement pyGlobalStatementTree) {
            pyGlobalStatementTree.variables().forEach(name -> {
                this.moduleScope.addBindingUsage((Name)name, Usage.Kind.GLOBAL_DECLARATION, null);
                this.currentScope().addGlobalName(name.name());
            });
            super.visitGlobalStatement(pyGlobalStatementTree);
        }

        @Override
        public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
            pyNonlocalStatementTree.variables().stream().map(Name::name).forEach(name -> this.currentScope().addNonLocalName((String)name));
            super.visitNonlocalStatement(pyNonlocalStatementTree);
        }

        @Override
        public void visitExceptClause(ExceptClause exceptClause) {
            SymbolUtils.boundNamesFromExpression(exceptClause.exceptionInstance()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.EXCEPTION_INSTANCE));
            super.visitExceptClause(exceptClause);
        }

        @Override
        public void visitWithItem(WithItem withItem) {
            SymbolUtils.boundNamesFromExpression(withItem.expression()).forEach(name -> this.addBindingUsage((Name)name, Usage.Kind.WITH_INSTANCE));
            super.visitWithItem(withItem);
        }

        @Override
        public void visitCapturePattern(CapturePattern capturePattern) {
            this.addBindingUsage(capturePattern.name(), Usage.Kind.PATTERN_DECLARATION);
            super.visitCapturePattern(capturePattern);
        }

        private void createScope(Tree tree, @Nullable Scope parent) {
            SymbolTableBuilder.this.scopesByRootTree.put(tree, new Scope(parent, tree, SymbolTableBuilder.this.pythonFile, SymbolTableBuilder.this.fullyQualifiedModuleName, SymbolTableBuilder.this.projectLevelSymbolTable));
        }

        private void addBindingUsage(Name nameTree, Usage.Kind usage) {
            this.addBindingUsage(nameTree, usage, null);
        }

        private void addBindingUsage(Name nameTree, Usage.Kind usage, @Nullable String fullyQualifiedName) {
            this.currentScope().addBindingUsage(nameTree, usage, fullyQualifiedName);
        }
    }

    private class SecondPhaseVisitor
    extends ScopeVisitor {
        private SecondPhaseVisitor() {
        }

        @Override
        public void visitFileInput(FileInput tree) {
            this.enterScope(tree);
            super.visitFileInput(tree);
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.scan(pyFunctionDefTree.decorators());
            this.enterScope(pyFunctionDefTree);
            this.scan(pyFunctionDefTree.name());
            this.scan(pyFunctionDefTree.typeParams());
            this.scan(pyFunctionDefTree.parameters());
            this.scan(pyFunctionDefTree.returnTypeAnnotation());
            this.scan(pyFunctionDefTree.body());
            this.leaveScope();
        }

        @Override
        public void visitParameter(Parameter parameter) {
            Tree currentScopeTree = this.leaveScope();
            this.scan(parameter.defaultValue());
            this.enterScope(currentScopeTree);
            this.scan(parameter.name());
            this.scan(parameter.typeAnnotation());
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
            this.enterScope(pyLambdaExpressionTree);
            super.visitLambda(pyLambdaExpressionTree);
            this.leaveScope();
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.enterScope(tree);
            this.scan(tree.resultExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitDictCompExpression(DictCompExpression tree) {
            this.enterScope(tree);
            this.scan(tree.keyExpression());
            this.scan(tree.valueExpression());
            ComprehensionFor comprehensionFor = tree.comprehensionFor();
            this.scan(comprehensionFor.loopExpression());
            this.leaveScope();
            this.scan(comprehensionFor.iterable());
            this.enterScope(tree);
            this.scan(comprehensionFor.nestedClause());
            this.leaveScope();
        }

        @Override
        public void visitTypeAnnotation(TypeAnnotation tree) {
            if (tree.is(Tree.Kind.PARAMETER_TYPE_ANNOTATION) || tree.is(Tree.Kind.RETURN_TYPE_ANNOTATION)) {
                Tree currentScopeTree = this.leaveScope();
                super.visitTypeAnnotation(tree);
                this.enterScope(currentScopeTree);
                super.visitTypeAnnotation(tree);
            } else {
                super.visitTypeAnnotation(tree);
            }
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
            this.scan(pyClassDefTree.args());
            this.scan(pyClassDefTree.decorators());
            this.enterScope(pyClassDefTree);
            this.scan(pyClassDefTree.name());
            SymbolUtils.resolveTypeHierarchy(pyClassDefTree, pyClassDefTree.name().symbol(), SymbolTableBuilder.this.pythonFile, SymbolTableBuilder.this.scopesByRootTree.get((Object)SymbolTableBuilder.this.fileInput).symbolsByName);
            this.scan(pyClassDefTree.body());
            this.leaveScope();
        }

        @Override
        public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
            HasSymbol hasSymbol;
            Symbol qualifierSymbol;
            super.visitQualifiedExpression(qualifiedExpression);
            Expression expression = qualifiedExpression.qualifier();
            if (expression instanceof HasSymbol && (qualifierSymbol = (hasSymbol = (HasSymbol)((Object)expression)).symbol()) != null) {
                Usage.Kind usageKind = SymbolTableBuilder.this.assignmentLeftHandSides.contains(qualifiedExpression) ? Usage.Kind.ASSIGNMENT_LHS : Usage.Kind.OTHER;
                ((SymbolImpl)qualifierSymbol).addOrCreateChildUsage(qualifiedExpression.name(), usageKind);
            }
        }

        @Override
        public void visitName(Name pyNameTree) {
            if (!pyNameTree.isVariable()) {
                return;
            }
            this.addSymbolUsage(pyNameTree);
            super.visitName(pyNameTree);
        }

        private void addSymbolUsage(Name nameTree) {
            Scope scope = SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
            SymbolImpl symbol = scope.resolve(nameTree.name());
            if (symbol != null && symbol.usages().stream().noneMatch(usage -> usage.tree().equals(nameTree))) {
                symbol.addUsage(nameTree, Usage.Kind.OTHER);
            }
        }
    }

    private class ThirdPhaseVisitor
    extends BaseTreeVisitor {
        private ThirdPhaseVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
            ParameterList parameters = functionDef.parameters();
            if (functionSymbol != null) {
                TypeAnnotation typeAnnotation;
                FunctionSymbolImpl functionSymbolImpl = (FunctionSymbolImpl)functionSymbol;
                if (parameters != null) {
                    functionSymbolImpl.setParametersWithType(parameters);
                }
                if ((typeAnnotation = functionDef.returnTypeAnnotation()) != null) {
                    functionSymbolImpl.setDeclaredReturnType(InferredTypes.fromTypeAnnotation(typeAnnotation));
                }
            }
            super.visitFunctionDef(functionDef);
        }

        @Override
        public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
            if (annotatedAssignment.variable().is(Tree.Kind.NAME)) {
                Name variable = (Name)annotatedAssignment.variable();
                TypeAnnotation annotation = annotatedAssignment.annotation();
                Symbol symbol = variable.symbol();
                Optional.ofNullable(symbol).ifPresent(s -> ((SymbolImpl)symbol).setInferredType(InferredTypes.fromTypeAnnotation(annotation)));
            }
            super.visitAnnotatedAssignment(annotatedAssignment);
        }

        @Override
        public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
            super.visitQualifiedExpression(qualifiedExpression);
            TreeUtils.getSymbolFromTree(qualifiedExpression.qualifier()).filter(symbol -> symbol.kind() == Symbol.Kind.CLASS).map(ClassSymbol.class::cast).flatMap(classSymbol -> classSymbol.resolveMember(qualifiedExpression.name().name())).ifPresent(member -> {
                Usage.Kind usageKind = SymbolTableBuilder.this.assignmentLeftHandSides.contains(qualifiedExpression) ? Usage.Kind.ASSIGNMENT_LHS : Usage.Kind.OTHER;
                ((SymbolImpl)member).addUsage(qualifiedExpression.name(), usageKind);
            });
        }
    }

    private static class SymbolToUpdate {
        final Symbol symbol;
        final AmbiguousSymbol ambiguousSymbol;

        SymbolToUpdate(Symbol symbol, AmbiguousSymbol ambiguousSymbol) {
            this.symbol = symbol;
            this.ambiguousSymbol = ambiguousSymbol;
        }
    }

    private class ScopeVisitor
    extends BaseTreeVisitor {
        private final Deque<Tree> scopeRootTrees = new LinkedList<Tree>();
        protected Scope moduleScope;

        private ScopeVisitor() {
        }

        Tree currentScopeRootTree() {
            return this.scopeRootTrees.peek();
        }

        void enterScope(Tree tree) {
            this.scopeRootTrees.push(tree);
        }

        Tree leaveScope() {
            return this.scopeRootTrees.pop();
        }

        Scope currentScope() {
            return SymbolTableBuilder.this.scopesByRootTree.get(this.currentScopeRootTree());
        }
    }
}

