/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.DescriptorUtils;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.SymbolTable;
import org.sonar.python.semantic.v2.SymbolTableBuilderV2;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.TypeInferenceV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.semantic.v2.converter.PythonTypeToDescriptorConverter;
import org.sonar.python.semantic.v2.typeshed.TypeShedDescriptorsProvider;
import org.sonar.python.semantic.v2.typetable.BasicTypeTable;
import org.sonar.python.semantic.v2.typetable.ProjectLevelTypeTable;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeChecker;

public class ProjectLevelSymbolTable {
    private final PythonTypeToDescriptorConverter pythonTypeToDescriptorConverter = new PythonTypeToDescriptorConverter();
    private final Map<String, Set<Descriptor>> globalDescriptorsByModuleName = new ConcurrentHashMap<String, Set<Descriptor>>();
    private Map<String, Descriptor> globalDescriptorsByFQN;
    private final Set<String> djangoViewsFQN = new HashSet<String>();
    private final Map<String, Set<String>> importsByModule = new ConcurrentHashMap<String, Set<String>>();
    private final Set<String> projectBasePackages = new HashSet<String>();
    private TypeShedDescriptorsProvider typeShedDescriptorsProvider = null;
    private Set<Symbol> cachedSymbols = null;

    public static ProjectLevelSymbolTable empty() {
        return new ProjectLevelSymbolTable();
    }

    public static ProjectLevelSymbolTable from(Map<String, Set<Descriptor>> globalDescriptorsByModuleName) {
        ProjectLevelSymbolTable projectLevelSymbolTable = ProjectLevelSymbolTable.empty();
        for (Map.Entry<String, Set<Descriptor>> entry : globalDescriptorsByModuleName.entrySet()) {
            Set<Descriptor> descriptors = entry.getValue();
            projectLevelSymbolTable.globalDescriptorsByModuleName.put(entry.getKey(), descriptors);
        }
        return projectLevelSymbolTable;
    }

    private ProjectLevelSymbolTable() {
    }

    public void removeModule(String packageName, String fileName) {
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, fileName);
        this.globalDescriptorsByModuleName.remove(fullyQualifiedModuleName);
        this.globalDescriptorsByFQN = null;
    }

    public void addModule(FileInput fileInput, String packageName, PythonFile pythonFile) {
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        SymbolTable symbolTable = new SymbolTableBuilderV2(fileInput).build();
        TypeInferenceV2 typeInferenceV2 = new TypeInferenceV2(new BasicTypeTable(new ProjectLevelTypeTable(this)), pythonFile, symbolTable, packageName);
        Map<SymbolV2, Set<PythonType>> typesBySymbol = typeInferenceV2.inferTopLevelTypes(fileInput);
        this.importsByModule.put(fullyQualifiedModuleName, typeInferenceV2.importedModulesFQN());
        Set<Descriptor> moduleDescriptors = typesBySymbol.entrySet().stream().filter(entry -> ProjectLevelSymbolTable.isNotMissingType((Set)entry.getValue())).map(entry -> {
            Descriptor descriptor = this.pythonTypeToDescriptorConverter.convert(fullyQualifiedModuleName, (SymbolV2)entry.getKey(), (Set)entry.getValue());
            return Map.entry((SymbolV2)entry.getKey(), descriptor);
        }).filter(entry -> Objects.requireNonNull(((Descriptor)entry.getValue()).fullyQualifiedName()).startsWith(fullyQualifiedModuleName) && !((SymbolV2)entry.getKey()).usages().stream().anyMatch(u -> u.kind().equals((Object)UsageV2.Kind.IMPORT))).map(Map.Entry::getValue).collect(Collectors.toSet());
        this.globalDescriptorsByModuleName.merge(fullyQualifiedModuleName, moduleDescriptors, ProjectLevelSymbolTable::mergeDescriptors);
        this.addModuleToGlobalSymbolsByFQN(moduleDescriptors);
        DjangoViewsVisitor djangoViewsVisitor = new DjangoViewsVisitor(fullyQualifiedModuleName);
        fileInput.accept(djangoViewsVisitor);
    }

    private static Set<Descriptor> mergeDescriptors(Set<Descriptor> oldDescriptors, Set<Descriptor> newDescriptors) {
        Map<String, Descriptor> oldDescriptorsByFqn = oldDescriptors.stream().collect(Collectors.toMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        Map<String, Descriptor> newDescriptorsByFqn = newDescriptors.stream().collect(Collectors.toMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        Map<String, Descriptor> mergedDescriptorsByFqn = ProjectLevelSymbolTable.mergeDescriptors(oldDescriptorsByFqn, newDescriptorsByFqn);
        return Set.copyOf(mergedDescriptorsByFqn.values());
    }

    private static Map<String, Descriptor> mergeDescriptors(Map<String, Descriptor> oldDescriptorsByFqn, Map<String, Descriptor> newDescriptorsByFqn) {
        HashMap<String, Descriptor> mergedMap = new HashMap<String, Descriptor>(oldDescriptorsByFqn);
        newDescriptorsByFqn.forEach((fqn, descriptor) -> mergedMap.merge((String)fqn, (Descriptor)descriptor, ProjectLevelSymbolTable::mergeDescriptors));
        return mergedMap;
    }

    @CheckForNull
    private static Descriptor mergeDescriptors(@Nullable Descriptor oldDescriptor, @Nullable Descriptor newDescriptor) {
        if (oldDescriptor == newDescriptor) {
            return oldDescriptor;
        }
        return AmbiguousDescriptor.create(oldDescriptor, newDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNotMissingType(Set<PythonType> types) {
        if (types.isEmpty()) return false;
        if (!types.stream().noneMatch(UnknownType.UnresolvedImportType.class::isInstance)) return false;
        return true;
    }

    private void addModuleToGlobalSymbolsByFQN(Set<Descriptor> descriptors) {
        Map<String, Descriptor> globalDescriptors = this.globalDescriptorsByFQN();
        Map moduleDescriptorsByFQN = descriptors.stream().filter(d -> d.fullyQualifiedName() != null).collect(Collectors.toMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        moduleDescriptorsByFQN.forEach((fqn, descriptor) -> globalDescriptors.merge((String)fqn, (Descriptor)descriptor, ProjectLevelSymbolTable::mergeDescriptors));
    }

    private synchronized Map<String, Descriptor> globalDescriptorsByFQN() {
        if (this.globalDescriptorsByFQN == null) {
            this.globalDescriptorsByFQN = this.globalDescriptorsByModuleName.values().stream().flatMap(Collection::stream).filter(descriptor -> descriptor.fullyQualifiedName() != null).collect(Collectors.toConcurrentMap(Descriptor::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousDescriptor.create(xva$0, xva$1)));
        }
        return this.globalDescriptorsByFQN;
    }

    @CheckForNull
    public Symbol getSymbol(@Nullable String fullyQualifiedName) {
        return this.getSymbol(fullyQualifiedName, null);
    }

    public Symbol getSymbol(@Nullable String fullyQualifiedName, @Nullable String localSymbolName) {
        return this.getSymbol(fullyQualifiedName, localSymbolName, new HashMap<Descriptor, Symbol>(), new HashMap<String, Symbol>());
    }

    public Symbol getSymbol(@Nullable String fullyQualifiedName, @Nullable String localSymbolName, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        if (fullyQualifiedName == null) {
            return null;
        }
        Descriptor descriptor = this.globalDescriptorsByFQN().get(fullyQualifiedName);
        return descriptor == null ? null : DescriptorUtils.symbolFromDescriptor(descriptor, this, localSymbolName, createdSymbolsByDescriptor, createdSymbolsByFqn);
    }

    @CheckForNull
    public synchronized Set<Symbol> getSymbolsFromModule(@Nullable String moduleName) {
        Set<Descriptor> descriptors = this.getDescriptorsFromModule(moduleName);
        if (descriptors == null) {
            return null;
        }
        HashMap createdSymbolsByDescriptor = new HashMap();
        HashMap createdSymbolsByFqn = new HashMap();
        return descriptors.stream().map(desc -> DescriptorUtils.symbolFromDescriptor(desc, this, null, createdSymbolsByDescriptor, createdSymbolsByFqn)).collect(Collectors.toSet());
    }

    @CheckForNull
    public Set<Descriptor> getDescriptorsFromModule(@Nullable String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return this.globalDescriptorsByModuleName.get(moduleName);
    }

    public Map<String, Set<String>> importsByModule() {
        return Collections.unmodifiableMap(this.importsByModule);
    }

    public void insertEntry(String moduleName, Set<Descriptor> descriptors) {
        this.globalDescriptorsByModuleName.put(moduleName, descriptors);
    }

    @CheckForNull
    public Set<Descriptor> descriptorsForModule(String moduleName) {
        return this.globalDescriptorsByModuleName.get(moduleName);
    }

    private synchronized void addDjangoView(String fqn) {
        this.djangoViewsFQN.add(fqn);
    }

    public boolean isDjangoView(@Nullable String fqn) {
        return this.djangoViewsFQN.contains(fqn);
    }

    public synchronized void addProjectPackage(String projectPackage) {
        this.projectBasePackages.add(projectPackage.split("\\.", 2)[0]);
    }

    public Set<String> projectBasePackages() {
        return this.projectBasePackages;
    }

    public TypeShedDescriptorsProvider typeShedDescriptorsProvider() {
        if (this.typeShedDescriptorsProvider == null) {
            this.typeShedDescriptorsProvider = new TypeShedDescriptorsProvider(this.projectBasePackages);
        }
        return this.typeShedDescriptorsProvider;
    }

    public Collection<Symbol> stubFilesSymbols() {
        if (this.cachedSymbols != null) {
            return this.cachedSymbols;
        }
        HashMap<String, Symbol> symbolsByFqn = new HashMap<String, Symbol>();
        this.cachedSymbols = new HashSet<Symbol>();
        for (Descriptor descriptor : this.typeShedDescriptorsProvider.stubFilesDescriptors()) {
            if (descriptor.fullyQualifiedName() == null) continue;
            Symbol symbol = symbolsByFqn.computeIfAbsent(descriptor.fullyQualifiedName(), k -> DescriptorUtils.symbolFromDescriptor(descriptor, this, null, new HashMap<Descriptor, Symbol>(), new HashMap<String, Symbol>()));
            this.cachedSymbols.add(symbol);
        }
        return this.cachedSymbols;
    }

    private class DjangoViewsVisitor
    extends BaseTreeVisitor {
        String fullyQualifiedModuleName;
        private TypeCheckBuilder confPathCall = null;
        private TypeCheckBuilder pathCall = null;

        public DjangoViewsVisitor(String fullyQualifiedModuleName) {
            this.fullyQualifiedModuleName = fullyQualifiedModuleName;
        }

        @Override
        public void visitFileInput(FileInput fileInput) {
            TypeChecker typeChecker = new TypeChecker(new BasicTypeTable(new ProjectLevelTypeTable(ProjectLevelSymbolTable.this)));
            this.confPathCall = typeChecker.typeCheckBuilder().isTypeWithName("django.urls.conf.path");
            this.pathCall = typeChecker.typeCheckBuilder().isTypeWithName("django.urls.path");
            super.visitFileInput(fileInput);
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            RegularArgument viewArgument;
            super.visitCallExpression(callExpression);
            if (this.isCallRegisteringDjangoView(callExpression) && (viewArgument = TreeUtils.nthArgumentOrKeyword(1, "view", callExpression.arguments())) != null) {
                PythonType pythonType = viewArgument.expression().typeV2();
                if (pythonType instanceof UnknownType.UnresolvedImportType) {
                    UnknownType.UnresolvedImportType unresolvedImportType = (UnknownType.UnresolvedImportType)pythonType;
                    String importPath = unresolvedImportType.importPath();
                    ProjectLevelSymbolTable.this.addDjangoView(importPath);
                } else if (pythonType instanceof FunctionType) {
                    FunctionType functionType = (FunctionType)pythonType;
                    ProjectLevelSymbolTable.this.addDjangoView(functionType.fullyQualifiedName());
                }
            }
        }

        private boolean isCallRegisteringDjangoView(CallExpression callExpression) {
            TriBool isConfPathCall = this.confPathCall.check(callExpression.callee().typeV2());
            TriBool isPathCall = this.pathCall.check(callExpression.callee().typeV2());
            return isConfPathCall.equals((Object)TriBool.TRUE) || isPathCall.equals((Object)TriBool.TRUE);
        }
    }
}

