/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.project.config;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.project.config.ProjectConfigurationBuilder;
import org.sonar.python.tree.TreeUtils;

public class SignatureBasedAwsLambdaHandlersCollector {
    public static final String AWS_LAMBDA_HANDLER_NAME_PATTERN = ".*(?:(_handler)|(Handler))$";
    public static final Set<String> EVENT_PARAM_ACCEPTABLE_NAMES = Set.of("event");
    public static final Set<String> CONTEXT_PARAM_ACCEPTABLE_NAMES = Set.of("ctx", "context");

    public void collect(ProjectConfigurationBuilder configBuilder, Tree rootTree, String packageName) {
        CollectorVisitor visitor = new CollectorVisitor(configBuilder, packageName);
        rootTree.accept(visitor);
    }

    private static class CollectorVisitor
    extends BaseTreeVisitor {
        private final ProjectConfigurationBuilder configBuilder;
        private final String packageName;

        private CollectorVisitor(ProjectConfigurationBuilder configBuilder, String packageName) {
            this.configBuilder = configBuilder;
            this.packageName = packageName;
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            String name = functionDef.name().name();
            if (!name.matches(SignatureBasedAwsLambdaHandlersCollector.AWS_LAMBDA_HANDLER_NAME_PATTERN)) {
                return;
            }
            ParameterList parameters = functionDef.parameters();
            if (parameters == null) {
                return;
            }
            List<String> parameterNames = parameters.all().stream().flatMap(TreeUtils.toStreamInstanceOfMapper(Parameter.class)).map(Parameter::name).filter(Objects::nonNull).map(Name::name).toList();
            PythonType pythonType = functionDef.name().typeV2();
            if (pythonType instanceof FunctionType) {
                FunctionType functionType = (FunctionType)pythonType;
                if (parameterNames.size() == 2 && EVENT_PARAM_ACCEPTABLE_NAMES.contains(parameterNames.get(0)) && CONTEXT_PARAM_ACCEPTABLE_NAMES.contains(parameterNames.get(1))) {
                    String fullyQualifiedName = functionType.fullyQualifiedName();
                    this.configBuilder.addAwsLambdaHandler(this.packageName, fullyQualifiedName);
                }
            }
        }
    }
}

