/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.project.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.python.api.project.configuration.AwsLambdaHandlerInfo;
import org.sonar.plugins.python.api.project.configuration.AwsProjectConfiguration;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="MODULE")
public class ProjectConfigurationBuilder {
    private final Map<String, Set<String>> awsLambdaHandlersByPackage = new ConcurrentHashMap<String, Set<String>>();

    public ProjectConfigurationBuilder addAwsLambdaHandler(String packageName, String fullyQualifiedName) {
        this.awsLambdaHandlersByPackage.computeIfAbsent(packageName, k -> new HashSet()).add(fullyQualifiedName);
        return this;
    }

    public ProjectConfigurationBuilder removePackageAwsLambdaHandlers(String packageName) {
        this.awsLambdaHandlersByPackage.remove(packageName);
        return this;
    }

    public ProjectConfiguration build() {
        return new ProjectConfiguration(new AwsProjectConfiguration(this.awsLambdaHandlersByPackage.values().stream().flatMap(Collection::stream).map(AwsLambdaHandlerInfo::new).collect(Collectors.toSet())));
    }
}

