/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.python.metrics.CognitiveComplexityVisitor;
import org.sonar.python.metrics.ComplexityVisitor;
import org.sonar.python.metrics.FileLinesVisitor;

public class FileMetrics {
    private int numberOfStatements;
    private int numberOfClasses;
    private final ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    private final CognitiveComplexityVisitor cognitiveComplexityVisitor = new CognitiveComplexityVisitor(null);
    private final FileLinesVisitor fileLinesVisitor;
    private List<Integer> functionComplexities = new ArrayList<Integer>();

    public FileMetrics(PythonVisitorContext context, boolean isNotebook) {
        FileInput fileInput = context.rootTree();
        this.fileLinesVisitor = new FileLinesVisitor(isNotebook);
        this.fileLinesVisitor.scanFile(context);
        this.numberOfStatements = this.fileLinesVisitor.getStatements();
        this.numberOfClasses = this.fileLinesVisitor.getClassDefs();
        fileInput.accept(this.complexityVisitor);
        fileInput.accept(this.cognitiveComplexityVisitor);
        fileInput.accept(new FunctionVisitor());
    }

    public FileMetrics(PythonVisitorContext context) {
        this(context, false);
    }

    public int numberOfStatements() {
        return this.numberOfStatements;
    }

    public int numberOfFunctions() {
        return this.functionComplexities.size();
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int complexity() {
        return this.complexityVisitor.getComplexity();
    }

    public int cognitiveComplexity() {
        return this.cognitiveComplexityVisitor.getComplexity();
    }

    public List<Integer> functionComplexities() {
        return this.functionComplexities;
    }

    public FileLinesVisitor fileLinesVisitor() {
        return this.fileLinesVisitor;
    }

    private class FunctionVisitor
    extends BaseTreeVisitor {
        private FunctionVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            FileMetrics.this.functionComplexities.add(ComplexityVisitor.complexity(pyFunctionDefTree));
            super.visitFunctionDef(pyFunctionDefTree);
        }
    }
}

