/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.FStringAndTStringChannel;
import org.sonar.python.lexer.IPynbCellDelimiterChannel;
import org.sonar.python.lexer.IndentationChannel;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.NewLineChannel;
import org.sonar.python.lexer.StringLiteralsChannel;

public final class PythonLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BYTES_PREFIX = "([bB][Rr]?|[rR][bB]?)";
    private static final String IMAGINARY_SUFFIX = "(j|J)";
    private static final String LONG_INTEGER_SUFFIX = "(l|L)";
    private static final String UNICODE_CHAR = "[^\u0000-\u007f]";
    private static final String IDENTIFIER_START = "[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_]";
    private static final String IDENTIFIER_CONTINUE = "[[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_]\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}]";
    private static final String SINGLE_QUOTE_STRING = "'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'";
    private static final String DOUBLE_QUOTES_STRING = "\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"";
    private static final String NUMBER_REGEX = "[0-9]++(_?[0-9])*+";

    private PythonLexer() {
    }

    public static Lexer create(LexerState lexerState) {
        Lexer.Builder builder = Lexer.builder().withFailIfNoChannelToConsumeOneCharacter(true);
        PythonLexer.addCommonChannels(builder, lexerState);
        return builder.build();
    }

    public static Lexer ipynbLexer(LexerState lexerState) {
        Lexer.Builder builder = Lexer.builder().withFailIfNoChannelToConsumeOneCharacter(true);
        builder.withChannel(new IPynbCellDelimiterChannel(lexerState));
        PythonLexer.addCommonChannels(builder, lexerState);
        return builder.build();
    }

    private static void addCommonChannels(Lexer.Builder builder, LexerState lexerState) {
        builder.withChannel(new NewLineChannel(lexerState)).withChannel(new IndentationChannel(lexerState)).withChannel(new BlackHoleChannel("\\s")).withChannel(RegexpChannelBuilder.commentRegexp("#[^\\n\\r]*+")).withChannel(new StringLiteralsChannel()).withChannel(new FStringAndTStringChannel(lexerState)).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.STRING, "([bB][Rr]?|[rR][bB]?)'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.STRING, "([bB][Rr]?|[rR][bB]?)\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++(_?[0-9])*+\\.[0-9]*+(_?[0-9])*+([Ee][+-]?+[0-9_]++)?+(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "\\.[0-9]++(_?[0-9])*+([Ee][+-]?+[0-9_]++)?+(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++(_?[0-9])*+([Ee][+-]?+[0-9_]++)(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++(_?[0-9])*+(j|J)")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[oO]?+(_?[0-7])++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[xX](_?[0-9a-fA-F])++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[bB](_?[01])++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[1-9](_?[0-9])*+(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0(_?0)*+(l|L)?+")).withChannel(new IdentifierAndKeywordChannel(RegexpChannelBuilder.and(RegexpChannelBuilder.or(IDENTIFIER_START, UNICODE_CHAR), RegexpChannelBuilder.o2n(RegexpChannelBuilder.or(IDENTIFIER_CONTINUE, UNICODE_CHAR))), true, new TokenType[][]{PythonKeyword.values()})).withChannel(new PunctuatorChannel(PythonPunctuator.values())).withChannel(new UnknownCharacterChannel());
    }
}

