/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.FStringState;
import org.sonar.python.lexer.LexerState;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class FStringAndTStringChannel
extends Channel<Lexer> {
    private static final char EOF = '\uffff';
    private final LexerState lexerState;
    private final StringBuilder sb = new StringBuilder();
    private static final Set<Character> QUOTES = Set.of(Character.valueOf('\"'), Character.valueOf('\''));
    private static final Set<Character> PREFIXES = Set.of(Character.valueOf('F'), Character.valueOf('T'));
    private static final Set<String> ESCAPED_CHARS = Set.of("{{", "}}");

    public FStringAndTStringChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    @Override
    public boolean consume(CodeReader code, Lexer output) {
        char c = code.charAt(0);
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        FStringState currentState = this.lexerState.fStringStateStack.peek();
        if (FStringAndTStringChannel.canConsumeFStringPrefix(this.sb, code)) {
            char quote = code.charAt(0);
            PythonTokenType startToken = this.sb.indexOf("t") >= 0 || this.sb.indexOf("T") >= 0 ? PythonTokenType.TSTRING_START : PythonTokenType.FSTRING_START;
            boolean isRawString = this.sb.indexOf("r") >= 0 || this.sb.indexOf("R") >= 0;
            StringBuilder quotes = FStringAndTStringChannel.consumeFStringQuotes(code, quote);
            FStringState newState = new FStringState(FStringState.Mode.FSTRING_MODE, this.lexerState.brackets, isRawString);
            newState.setQuote(Character.valueOf(quote));
            newState.setNumberOfQuotes(quotes.length());
            this.lexerState.fStringStateStack.push(newState);
            Token fStringStartToken = FStringAndTStringChannel.buildToken(startToken, this.sb.append((CharSequence)quotes).toString(), output, line, column);
            this.sb.setLength(0);
            ArrayList<Token> tokens = new ArrayList<Token>();
            tokens.add(fStringStartToken);
            return this.consumeFStringMiddle(tokens, this.sb, newState, code, output);
        }
        FStringState.Mode currentMode = currentState.getTokenizerMode();
        if (currentMode == FStringState.Mode.REGULAR_MODE && this.lexerState.fStringStateStack.size() > 1) {
            if (c == '}' && currentState.getBrackets() - 1 == this.lexerState.brackets) {
                Token rCurlyBraceToken = FStringAndTStringChannel.buildToken(PythonPunctuator.RCURLYBRACE, "}", output, line, column);
                code.pop();
                ArrayList<Token> tokens = new ArrayList<Token>();
                tokens.add(rCurlyBraceToken);
                this.lexerState.fStringStateStack.pop();
                FStringState previousState = this.lexerState.fStringStateStack.peek();
                return this.consumeFStringMiddle(tokens, this.sb, previousState, code, output);
            }
            if (c == ':' && this.lexerState.brackets == currentState.getBrackets()) {
                Token formatSpecifier = FStringAndTStringChannel.buildToken(PythonPunctuator.COLON, ":", output, line, column);
                code.pop();
                ArrayList<Token> tokens = new ArrayList<Token>();
                tokens.add(formatSpecifier);
                FStringState newState = new FStringState(FStringState.Mode.FORMAT_SPECIFIER_MODE, this.lexerState.brackets, currentState.isRawString);
                this.lexerState.fStringStateStack.push(newState);
                return this.consumeFStringMiddle(tokens, this.sb, newState, code, output);
            }
        }
        return false;
    }

    private boolean consumeFStringMiddle(List<Token> tokens, StringBuilder sb, FStringState state, CodeReader code, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        FStringState.Mode currentMode = state.getTokenizerMode();
        while (code.charAt(0) != '\uffff') {
            if (currentMode == FStringState.Mode.FSTRING_MODE && FStringAndTStringChannel.isRawStringSingleBackSlash(code, state)) {
                sb.append((char)code.pop());
                continue;
            }
            if (currentMode == FStringState.Mode.FSTRING_MODE && (FStringAndTStringChannel.isEscapedChar(code) || FStringAndTStringChannel.isDoubleBackslashInRawString(state, code))) {
                sb.append((char)code.pop());
                sb.append((char)code.pop());
                continue;
            }
            if (code.charAt(0) == '{' && !FStringAndTStringChannel.isUnicodeChar(sb)) {
                FStringAndTStringChannel.addFStringMiddleToTokens(tokens, sb, output, line, column);
                this.addLCurlBraceAndSwitchToRegularMode(tokens, code, output, state);
                FStringAndTStringChannel.addTokens(tokens, output);
                return true;
            }
            if (currentMode == FStringState.Mode.FORMAT_SPECIFIER_MODE && code.charAt(0) == '}') {
                FStringAndTStringChannel.addFStringMiddleToTokens(tokens, sb, output, line, column);
                this.lexerState.fStringStateStack.pop();
                FStringAndTStringChannel.addTokens(tokens, output);
                return true;
            }
            if (currentMode == FStringState.Mode.FSTRING_MODE && FStringAndTStringChannel.areClosingQuotes(code, state)) {
                FStringAndTStringChannel.addFStringMiddleToTokens(tokens, sb, output, line, column);
                this.addFStringEndToTokens(code, state.getQuote().charValue(), tokens, output);
                FStringAndTStringChannel.addTokens(tokens, output);
                return true;
            }
            sb.append((char)code.pop());
        }
        return false;
    }

    private static boolean isDoubleBackslashInRawString(FStringState state, CodeReader code) {
        return state.isRawString && code.charAt(0) == '\\' && code.charAt(1) == '\\';
    }

    private static boolean canConsumeFStringPrefix(StringBuilder sb, CodeReader code) {
        Character firstChar = Character.valueOf(Character.toUpperCase(code.charAt(0)));
        Character secondChar = Character.valueOf(Character.toUpperCase(code.charAt(1)));
        if (PREFIXES.contains(firstChar) && QUOTES.contains(Character.valueOf(code.charAt(1)))) {
            sb.append((char)code.pop());
            return true;
        }
        if ((PREFIXES.contains(firstChar) && secondChar.charValue() == 'R' || PREFIXES.contains(secondChar) && firstChar.charValue() == 'R') && QUOTES.contains(Character.valueOf(code.charAt(2)))) {
            sb.append((char)code.pop());
            sb.append((char)code.pop());
            return true;
        }
        return false;
    }

    private static boolean isRawStringSingleBackSlash(CodeReader code, FStringState state) {
        return state.isRawString && code.charAt(0) == '\\' && !QUOTES.contains(Character.valueOf(code.charAt(1))) && code.charAt(1) != '\\';
    }

    private static boolean isUnicodeChar(StringBuilder sb) {
        int lastIndexOfUnicodeChar = sb.lastIndexOf("\\N");
        return lastIndexOfUnicodeChar >= 0 && lastIndexOfUnicodeChar == sb.length() - 2;
    }

    private static boolean isEscapedChar(CodeReader code) {
        return ESCAPED_CHARS.contains(String.valueOf(code.peek(2))) || code.peek() == 92;
    }

    private static boolean areClosingQuotes(CodeReader code, FStringState state) {
        char[] quotes = code.peek(state.getNumberOfQuotes());
        return IntStream.range(0, quotes.length).mapToObj(i -> Character.valueOf(quotes[i])).allMatch(state.getQuote()::equals);
    }

    private static void addFStringMiddleToTokens(List<Token> tokens, StringBuilder sb, Lexer output, int line, int column) {
        if (!sb.isEmpty()) {
            Token fStringMiddleToken = FStringAndTStringChannel.buildToken(PythonTokenType.FSTRING_MIDDLE, sb.toString(), output, line, column);
            sb.setLength(0);
            tokens.add(fStringMiddleToken);
        }
    }

    private void addFStringEndToTokens(CodeReader code, char quote, List<Token> tokens, Lexer output) {
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        StringBuilder endQuotes = FStringAndTStringChannel.consumeFStringQuotes(code, quote);
        this.lexerState.fStringStateStack.pop();
        Token fStringEndToken = FStringAndTStringChannel.buildToken(PythonTokenType.FSTRING_END, endQuotes.toString(), output, line, column);
        tokens.add(fStringEndToken);
    }

    private void addLCurlBraceAndSwitchToRegularMode(List<Token> tokens, CodeReader code, Lexer output, FStringState currentState) {
        Token curlyBraceToken = FStringAndTStringChannel.buildToken(PythonPunctuator.LCURLYBRACE, "{", output, code.getLinePosition(), code.getColumnPosition());
        code.pop();
        ++this.lexerState.brackets;
        FStringState updatedState = new FStringState(FStringState.Mode.REGULAR_MODE, this.lexerState.brackets, currentState.isRawString);
        this.lexerState.fStringStateStack.push(updatedState);
        tokens.add(curlyBraceToken);
    }

    private static StringBuilder consumeFStringQuotes(CodeReader code, char quote) {
        StringBuilder quotes = new StringBuilder();
        if (code.charAt(1) == quote && code.charAt(2) == quote) {
            quotes.append((char)code.pop());
            quotes.append((char)code.pop());
            quotes.append((char)code.pop());
        } else {
            quotes.append((char)code.pop());
        }
        return quotes;
    }

    private static void addTokens(List<Token> tokens, Lexer output) {
        output.addToken((Token[])tokens.toArray(Token[]::new));
    }

    private static Token buildToken(TokenType tokenType, String value, Lexer output, int line, int column) {
        return Token.builder().setType(tokenType).setValueAndOriginalValue(value).setURI(output.getURI()).setLine(line).setColumn(column).build();
    }
}

