/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.index;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.TypeAnnotationDescriptor;

public class FunctionDescriptor
implements Descriptor {
    private final String name;
    private final String fullyQualifiedName;
    private final List<Parameter> parameters;
    private final boolean isAsynchronous;
    private final boolean isInstanceMethod;
    private final List<String> decorators;
    private final boolean hasDecorators;
    @Nullable
    private final LocationInFile definitionLocation;
    @Nullable
    private final String annotatedReturnTypeName;
    @Nullable
    private final TypeAnnotationDescriptor typeAnnotationDescriptor;

    public FunctionDescriptor(String name, String fullyQualifiedName, List<Parameter> parameters, boolean isAsynchronous, boolean isInstanceMethod, List<String> decorators, boolean hasDecorators, @Nullable LocationInFile definitionLocation, @Nullable String annotatedReturnTypeName) {
        this(name, fullyQualifiedName, parameters, isAsynchronous, isInstanceMethod, decorators, hasDecorators, definitionLocation, annotatedReturnTypeName, null);
    }

    public FunctionDescriptor(String name, String fullyQualifiedName, List<Parameter> parameters, boolean isAsynchronous, boolean isInstanceMethod, List<String> decorators, boolean hasDecorators, @Nullable LocationInFile definitionLocation, @Nullable String annotatedReturnTypeName, @Nullable TypeAnnotationDescriptor typeAnnotationDescriptor) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.parameters = parameters;
        this.isAsynchronous = isAsynchronous;
        this.isInstanceMethod = isInstanceMethod;
        this.decorators = decorators;
        this.hasDecorators = hasDecorators;
        this.definitionLocation = definitionLocation;
        this.annotatedReturnTypeName = annotatedReturnTypeName;
        this.typeAnnotationDescriptor = typeAnnotationDescriptor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nonnull
    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public Descriptor.Kind kind() {
        return Descriptor.Kind.FUNCTION;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isInstanceMethod() {
        return this.isInstanceMethod;
    }

    public List<String> decorators() {
        return this.decorators;
    }

    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    @CheckForNull
    public LocationInFile definitionLocation() {
        return this.definitionLocation;
    }

    @CheckForNull
    public String annotatedReturnTypeName() {
        return this.annotatedReturnTypeName;
    }

    @CheckForNull
    public TypeAnnotationDescriptor typeAnnotationDescriptor() {
        return this.typeAnnotationDescriptor;
    }

    public static class FunctionDescriptorBuilder {
        private String name;
        private String fullyQualifiedName;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private boolean isAsynchronous = false;
        private boolean isInstanceMethod = false;
        private List<String> decorators = new ArrayList<String>();
        private boolean hasDecorators = false;
        private LocationInFile definitionLocation = null;
        private String annotatedReturnTypeName = null;
        private TypeAnnotationDescriptor typeAnnotationDescriptor = null;

        public FunctionDescriptorBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public FunctionDescriptorBuilder withFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public FunctionDescriptorBuilder withParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public FunctionDescriptorBuilder withIsAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            return this;
        }

        public FunctionDescriptorBuilder withIsInstanceMethod(boolean isInstanceMethod) {
            this.isInstanceMethod = isInstanceMethod;
            return this;
        }

        public FunctionDescriptorBuilder withDecorators(List<String> decorators) {
            this.decorators = decorators;
            return this;
        }

        public FunctionDescriptorBuilder withHasDecorators(boolean hasDecorators) {
            this.hasDecorators = hasDecorators;
            return this;
        }

        public FunctionDescriptorBuilder withDefinitionLocation(@Nullable LocationInFile definitionLocation) {
            this.definitionLocation = definitionLocation;
            return this;
        }

        public FunctionDescriptorBuilder withAnnotatedReturnTypeName(@Nullable String annotatedReturnTypeName) {
            this.annotatedReturnTypeName = annotatedReturnTypeName;
            return this;
        }

        public FunctionDescriptorBuilder withTypeAnnotationDescriptor(@Nullable TypeAnnotationDescriptor typeAnnotationDescriptor) {
            this.typeAnnotationDescriptor = typeAnnotationDescriptor;
            return this;
        }

        public FunctionDescriptor build() {
            return new FunctionDescriptor(this.name, this.fullyQualifiedName, this.parameters, this.isAsynchronous, this.isInstanceMethod, this.decorators, this.hasDecorators, this.definitionLocation, this.annotatedReturnTypeName, this.typeAnnotationDescriptor);
        }
    }

    public static class Parameter {
        private final String name;
        private final String annotatedType;
        private final boolean hasDefaultValue;
        private final boolean isKeywordVariadic;
        private final boolean isPositionalVariadic;
        private final boolean isKeywordOnly;
        private final boolean isPositionalOnly;
        private final LocationInFile location;

        public Parameter(@Nullable String name, @Nullable String annotatedType, boolean hasDefaultValue, boolean isKeywordOnly, boolean isPositionalOnly, boolean isPositionalVariadic, boolean isKeywordVariadic, @Nullable LocationInFile location) {
            this.name = name;
            this.annotatedType = annotatedType;
            this.hasDefaultValue = hasDefaultValue;
            this.isKeywordVariadic = isKeywordVariadic;
            this.isPositionalVariadic = isPositionalVariadic;
            this.isKeywordOnly = isKeywordOnly;
            this.isPositionalOnly = isPositionalOnly;
            this.location = location;
        }

        @CheckForNull
        public String name() {
            return this.name;
        }

        public String annotatedType() {
            return this.annotatedType;
        }

        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        public boolean isVariadic() {
            return this.isKeywordVariadic || this.isPositionalVariadic;
        }

        public boolean isKeywordOnly() {
            return this.isKeywordOnly;
        }

        public boolean isPositionalOnly() {
            return this.isPositionalOnly;
        }

        public boolean isKeywordVariadic() {
            return this.isKeywordVariadic;
        }

        public boolean isPositionalVariadic() {
            return this.isPositionalVariadic;
        }

        @CheckForNull
        public LocationInFile location() {
            return this.location;
        }
    }
}

