/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.types.protobuf.DescriptorsProtos;

public class DescriptorsToProtobuf {
    private DescriptorsToProtobuf() {
    }

    public static DescriptorsProtos.ModuleDescriptor toProtobufModuleDescriptor(Set<Descriptor> descriptors) {
        ArrayList<DescriptorsProtos.ClassDescriptor> classDescriptors = new ArrayList<DescriptorsProtos.ClassDescriptor>();
        ArrayList<DescriptorsProtos.FunctionDescriptor> functionDescriptors = new ArrayList<DescriptorsProtos.FunctionDescriptor>();
        ArrayList<DescriptorsProtos.VarDescriptor> varDescriptors = new ArrayList<DescriptorsProtos.VarDescriptor>();
        ArrayList<DescriptorsProtos.AmbiguousDescriptor> ambiguousDescriptors = new ArrayList<DescriptorsProtos.AmbiguousDescriptor>();
        for (Descriptor descriptor : descriptors) {
            Descriptor.Kind kind = descriptor.kind();
            if (kind == Descriptor.Kind.CLASS) {
                classDescriptors.add(DescriptorsToProtobuf.toProtobuf((ClassDescriptor)descriptor));
                continue;
            }
            if (kind == Descriptor.Kind.FUNCTION) {
                functionDescriptors.add(DescriptorsToProtobuf.toProtobuf((FunctionDescriptor)descriptor));
                continue;
            }
            if (kind == Descriptor.Kind.VARIABLE) {
                varDescriptors.add(DescriptorsToProtobuf.toProtobuf((VariableDescriptor)descriptor));
                continue;
            }
            ambiguousDescriptors.add(DescriptorsToProtobuf.toProtobuf((AmbiguousDescriptor)descriptor));
        }
        return DescriptorsProtos.ModuleDescriptor.newBuilder().addAllClassDescriptors(classDescriptors).addAllFunctionDescriptors(functionDescriptors).addAllVarDescriptors(varDescriptors).addAllAmbiguousDescriptors(ambiguousDescriptors).build();
    }

    public static DescriptorsProtos.AmbiguousDescriptor toProtobuf(AmbiguousDescriptor ambiguousDescriptor) {
        ArrayList<DescriptorsProtos.FunctionDescriptor> functionDescriptors = new ArrayList<DescriptorsProtos.FunctionDescriptor>();
        ArrayList<DescriptorsProtos.VarDescriptor> variableDescriptors = new ArrayList<DescriptorsProtos.VarDescriptor>();
        ArrayList<DescriptorsProtos.ClassDescriptor> classDescriptors = new ArrayList<DescriptorsProtos.ClassDescriptor>();
        for (Descriptor descriptor : ambiguousDescriptor.alternatives()) {
            Descriptor.Kind kind = descriptor.kind();
            if (kind == Descriptor.Kind.FUNCTION) {
                functionDescriptors.add(DescriptorsToProtobuf.toProtobuf((FunctionDescriptor)descriptor));
                continue;
            }
            if (kind == Descriptor.Kind.VARIABLE) {
                variableDescriptors.add(DescriptorsToProtobuf.toProtobuf((VariableDescriptor)descriptor));
                continue;
            }
            classDescriptors.add(DescriptorsToProtobuf.toProtobuf((ClassDescriptor)descriptor));
        }
        DescriptorsProtos.AmbiguousDescriptor.Builder builder = DescriptorsProtos.AmbiguousDescriptor.newBuilder();
        builder.setName(ambiguousDescriptor.name()).addAllClassDescriptors(classDescriptors).addAllFunctionDescriptors(functionDescriptors).addAllVarDescriptors(variableDescriptors);
        String fullyQualifiedName = ambiguousDescriptor.fullyQualifiedName();
        if (fullyQualifiedName != null) {
            builder.setFullyQualifiedName(fullyQualifiedName);
        }
        return builder.build();
    }

    public static DescriptorsProtos.ClassDescriptor toProtobuf(ClassDescriptor classDescriptor) {
        String metaclassFQN;
        ArrayList<DescriptorsProtos.FunctionDescriptor> functionMembers = new ArrayList<DescriptorsProtos.FunctionDescriptor>();
        ArrayList<DescriptorsProtos.VarDescriptor> variableMembers = new ArrayList<DescriptorsProtos.VarDescriptor>();
        ArrayList<DescriptorsProtos.AmbiguousDescriptor> ambiguousMembers = new ArrayList<DescriptorsProtos.AmbiguousDescriptor>();
        ArrayList<DescriptorsProtos.ClassDescriptor> classMembers = new ArrayList<DescriptorsProtos.ClassDescriptor>();
        for (Descriptor member : classDescriptor.members()) {
            Descriptor.Kind kind = member.kind();
            if (kind == Descriptor.Kind.FUNCTION) {
                functionMembers.add(DescriptorsToProtobuf.toProtobuf((FunctionDescriptor)member));
                continue;
            }
            if (kind == Descriptor.Kind.VARIABLE) {
                variableMembers.add(DescriptorsToProtobuf.toProtobuf((VariableDescriptor)member));
                continue;
            }
            if (kind == Descriptor.Kind.AMBIGUOUS) {
                ambiguousMembers.add(DescriptorsToProtobuf.toProtobuf((AmbiguousDescriptor)member));
                continue;
            }
            classMembers.add(DescriptorsToProtobuf.toProtobuf((ClassDescriptor)member));
        }
        DescriptorsProtos.ClassDescriptor.Builder builder = DescriptorsProtos.ClassDescriptor.newBuilder().setName(classDescriptor.name()).setFullyQualifiedName(classDescriptor.fullyQualifiedName()).addAllSuperClasses(classDescriptor.superClasses()).addAllFunctionMembers(functionMembers).addAllVarMembers(variableMembers).addAllAmbiguousMembers(ambiguousMembers).addAllClassMembers(classMembers).setHasDecorators(classDescriptor.hasDecorators()).setHasSuperClassWithoutDescriptor(classDescriptor.hasSuperClassWithoutDescriptor()).setHasMetaClass(classDescriptor.hasMetaClass()).setSupportsGenerics(classDescriptor.supportsGenerics());
        LocationInFile definitionLocation = classDescriptor.definitionLocation();
        if (definitionLocation != null) {
            builder.setDefinitionLocation(DescriptorsToProtobuf.toProtobuf(definitionLocation));
        }
        if ((metaclassFQN = classDescriptor.metaclassFQN()) != null) {
            builder.setMetaClassFQN(metaclassFQN);
        }
        return builder.build();
    }

    public static DescriptorsProtos.FunctionDescriptor toProtobuf(FunctionDescriptor functionDescriptor) {
        LocationInFile definitionLocation;
        DescriptorsProtos.FunctionDescriptor.Builder builder = DescriptorsProtos.FunctionDescriptor.newBuilder().setName(functionDescriptor.name()).setFullyQualifiedName(functionDescriptor.fullyQualifiedName()).addAllParameters(functionDescriptor.parameters().stream().map(DescriptorsToProtobuf::toProtobuf).toList()).setIsAsynchronous(functionDescriptor.isAsynchronous()).setIsInstanceMethod(functionDescriptor.isInstanceMethod()).addAllDecorators(functionDescriptor.decorators()).setHasDecorators(functionDescriptor.hasDecorators());
        String annotatedReturnTypeName = functionDescriptor.annotatedReturnTypeName();
        if (annotatedReturnTypeName != null) {
            builder.setAnnotatedReturnType(annotatedReturnTypeName);
        }
        if ((definitionLocation = functionDescriptor.definitionLocation()) != null) {
            builder.setDefinitionLocation(DescriptorsToProtobuf.toProtobuf(definitionLocation));
        }
        return builder.build();
    }

    public static DescriptorsProtos.ParameterDescriptor toProtobuf(FunctionDescriptor.Parameter parameterDescriptor) {
        LocationInFile location;
        DescriptorsProtos.ParameterDescriptor.Builder builder = DescriptorsProtos.ParameterDescriptor.newBuilder().setHasDefaultValue(parameterDescriptor.hasDefaultValue()).setIsKeywordVariadic(parameterDescriptor.isKeywordVariadic()).setIsPositionalVariadic(parameterDescriptor.isPositionalVariadic()).setIsKeywordOnly(parameterDescriptor.isKeywordOnly()).setIsPositionalOnly(parameterDescriptor.isPositionalOnly());
        String annotatedType = parameterDescriptor.annotatedType();
        if (parameterDescriptor.name() != null) {
            builder.setName(parameterDescriptor.name());
        }
        if (annotatedType != null) {
            builder.setAnnotatedType(annotatedType);
        }
        if ((location = parameterDescriptor.location()) != null) {
            builder.setDefinitionLocation(DescriptorsToProtobuf.toProtobuf(location));
        }
        return builder.build();
    }

    public static DescriptorsProtos.VarDescriptor toProtobuf(VariableDescriptor variableDescriptor) {
        String annotatedType;
        DescriptorsProtos.VarDescriptor.Builder builder = DescriptorsProtos.VarDescriptor.newBuilder();
        builder.setName(variableDescriptor.name());
        String fullyQualifiedName = variableDescriptor.fullyQualifiedName();
        if (fullyQualifiedName != null) {
            builder.setFullyQualifiedName(fullyQualifiedName);
        }
        if ((annotatedType = variableDescriptor.annotatedType()) != null) {
            builder.setAnnotatedType(annotatedType);
        }
        return builder.build();
    }

    public static DescriptorsProtos.LocationInFile toProtobuf(LocationInFile locationInFile) {
        return DescriptorsProtos.LocationInFile.newBuilder().setFileId(locationInFile.fileId()).setStartLine(locationInFile.startLine()).setStartLineOffset(locationInFile.startLineOffset()).setEndLine(locationInFile.endLine()).setEndLineOffset(locationInFile.endLineOffset()).build();
    }

    public static Set<Descriptor> fromProtobuf(DescriptorsProtos.ModuleDescriptor moduleDescriptorProto) {
        HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
        moduleDescriptorProto.getClassDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        moduleDescriptorProto.getFunctionDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        moduleDescriptorProto.getAmbiguousDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        moduleDescriptorProto.getVarDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        return descriptors;
    }

    public static AmbiguousDescriptor fromProtobuf(DescriptorsProtos.AmbiguousDescriptor ambiguousDescriptor) {
        String fullyQualifiedName = ambiguousDescriptor.hasFullyQualifiedName() ? ambiguousDescriptor.getFullyQualifiedName() : null;
        HashSet<Descriptor> descriptors = new HashSet<Descriptor>();
        ambiguousDescriptor.getClassDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        ambiguousDescriptor.getFunctionDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        ambiguousDescriptor.getVarDescriptorsList().forEach(proto -> descriptors.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        return new AmbiguousDescriptor(ambiguousDescriptor.getName(), fullyQualifiedName, descriptors);
    }

    public static ClassDescriptor fromProtobuf(DescriptorsProtos.ClassDescriptor classDescriptorProto) {
        String metaclassFQN = classDescriptorProto.hasMetaClassFQN() ? classDescriptorProto.getMetaClassFQN() : null;
        LocationInFile definitionLocation = classDescriptorProto.hasDefinitionLocation() ? DescriptorsToProtobuf.fromProtobuf(classDescriptorProto.getDefinitionLocation()) : null;
        String fullyQualifiedName = classDescriptorProto.getFullyQualifiedName();
        HashSet<Descriptor> members = new HashSet<Descriptor>();
        classDescriptorProto.getClassMembersList().forEach(proto -> members.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        classDescriptorProto.getFunctionMembersList().forEach(proto -> members.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        classDescriptorProto.getAmbiguousMembersList().forEach(proto -> members.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        classDescriptorProto.getVarMembersList().forEach(proto -> members.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        return new ClassDescriptor(classDescriptorProto.getName(), fullyQualifiedName, new ArrayList<String>(classDescriptorProto.getSuperClassesList()), members, classDescriptorProto.getHasDecorators(), definitionLocation, classDescriptorProto.getHasSuperClassWithoutDescriptor(), classDescriptorProto.getHasMetaClass(), metaclassFQN, classDescriptorProto.getSupportsGenerics());
    }

    public static FunctionDescriptor fromProtobuf(DescriptorsProtos.FunctionDescriptor functionDescriptorProto) {
        String fullyQualifiedName = functionDescriptorProto.getFullyQualifiedName();
        ArrayList<FunctionDescriptor.Parameter> parameters = new ArrayList<FunctionDescriptor.Parameter>();
        functionDescriptorProto.getParametersList().forEach(proto -> parameters.add(DescriptorsToProtobuf.fromProtobuf(proto)));
        LocationInFile definitionLocation = functionDescriptorProto.hasDefinitionLocation() ? DescriptorsToProtobuf.fromProtobuf(functionDescriptorProto.getDefinitionLocation()) : null;
        String annotatedReturnTypeName = functionDescriptorProto.hasAnnotatedReturnType() ? functionDescriptorProto.getAnnotatedReturnType() : null;
        return new FunctionDescriptor(functionDescriptorProto.getName(), fullyQualifiedName, parameters, functionDescriptorProto.getIsAsynchronous(), functionDescriptorProto.getIsInstanceMethod(), new ArrayList<String>(functionDescriptorProto.getDecoratorsList()), functionDescriptorProto.getHasDecorators(), definitionLocation, annotatedReturnTypeName);
    }

    public static FunctionDescriptor.Parameter fromProtobuf(DescriptorsProtos.ParameterDescriptor parameterDescriptorProto) {
        String name = parameterDescriptorProto.hasName() ? parameterDescriptorProto.getName() : null;
        String annotatedType = parameterDescriptorProto.hasAnnotatedType() ? parameterDescriptorProto.getAnnotatedType() : null;
        LocationInFile location = parameterDescriptorProto.hasDefinitionLocation() ? DescriptorsToProtobuf.fromProtobuf(parameterDescriptorProto.getDefinitionLocation()) : null;
        return new FunctionDescriptor.Parameter(name, annotatedType, parameterDescriptorProto.getHasDefaultValue(), parameterDescriptorProto.getIsKeywordOnly(), parameterDescriptorProto.getIsPositionalOnly(), parameterDescriptorProto.getIsPositionalVariadic(), parameterDescriptorProto.getIsKeywordVariadic(), location);
    }

    public static VariableDescriptor fromProtobuf(DescriptorsProtos.VarDescriptor varDescriptorProto) {
        String fullyQualifiedName = varDescriptorProto.hasFullyQualifiedName() ? varDescriptorProto.getFullyQualifiedName() : null;
        String annotatedType = varDescriptorProto.hasAnnotatedType() ? varDescriptorProto.getAnnotatedType() : null;
        return new VariableDescriptor(varDescriptorProto.getName(), fullyQualifiedName, annotatedType);
    }

    public static LocationInFile fromProtobuf(DescriptorsProtos.LocationInFile locationInFileProto) {
        return new LocationInFile(locationInFileProto.getFileId(), locationInFileProto.getStartLine(), locationInFileProto.getStartLineOffset(), locationInFileProto.getEndLine(), locationInFileProto.getEndLineOffset());
    }
}

