/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.index.AliasDescriptor;
import org.sonar.python.index.AmbiguousDescriptor;
import org.sonar.python.index.ClassDescriptor;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.FunctionDescriptor;
import org.sonar.python.index.VariableDescriptor;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.InferredTypes;

public class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static Symbol symbolFromDescriptor(Descriptor descriptor, ProjectLevelSymbolTable projectLevelSymbolTable, @Nullable String localSymbolName, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        if (createdSymbolsByDescriptor.containsKey(descriptor)) {
            return createdSymbolsByDescriptor.get(descriptor);
        }
        if (descriptor.fullyQualifiedName() != null && createdSymbolsByFqn.containsKey(descriptor.fullyQualifiedName())) {
            return createdSymbolsByFqn.get(descriptor.fullyQualifiedName());
        }
        String symbolName = localSymbolName != null ? localSymbolName : descriptor.name();
        switch (descriptor.kind()) {
            case CLASS: {
                return DescriptorUtils.createClassSymbol(descriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn, symbolName);
            }
            case FUNCTION: {
                return DescriptorUtils.createFunctionSymbol((FunctionDescriptor)descriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn, symbolName);
            }
            case VARIABLE: {
                VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
                return new SymbolImpl(symbolName, descriptor.fullyQualifiedName(), variableDescriptor.annotatedType());
            }
            case AMBIGUOUS: {
                HashSet<Symbol> alternatives = new HashSet<Symbol>();
                AmbiguousSymbolImpl ambiguousSymbol = new AmbiguousSymbolImpl(symbolName, descriptor.fullyQualifiedName(), alternatives);
                createdSymbolsByDescriptor.put(descriptor, ambiguousSymbol);
                alternatives.addAll(((AmbiguousDescriptor)descriptor).alternatives().stream().map(a -> DescriptorUtils.symbolFromDescriptor(a, projectLevelSymbolTable, symbolName, createdSymbolsByDescriptor, new HashMap<String, Symbol>())).collect(Collectors.toSet()));
                return ambiguousSymbol;
            }
            case ALIAS: {
                Descriptor recreatedDescriptor = DescriptorUtils.recreateDescriptorFromAlias((AliasDescriptor)descriptor);
                return DescriptorUtils.symbolFromDescriptor(recreatedDescriptor, projectLevelSymbolTable, symbolName, createdSymbolsByDescriptor, createdSymbolsByFqn);
            }
        }
        throw new IllegalStateException(String.format("Error while creating a Symbol from a Descriptor: Unexpected descriptor kind: %s", new Object[]{descriptor.kind()}));
    }

    private static Descriptor recreateDescriptorFromAlias(AliasDescriptor aliasDescriptor) {
        Descriptor originalDescriptor = aliasDescriptor.originalDescriptor();
        if (originalDescriptor instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)originalDescriptor;
            return DescriptorUtils.recreateFunctionDescriptor(aliasDescriptor, functionDescriptor);
        }
        if (originalDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)originalDescriptor;
            return DescriptorUtils.recreateClassDescriptor(aliasDescriptor, classDescriptor);
        }
        throw new IllegalStateException(String.format("Error while recreating a descriptor from an alias: Unexpected alias kind: %s", new Object[]{originalDescriptor.kind()}));
    }

    private static Descriptor recreateFunctionDescriptor(AliasDescriptor aliasDescriptor, FunctionDescriptor originalDescriptor) {
        FunctionDescriptor.FunctionDescriptorBuilder builder = new FunctionDescriptor.FunctionDescriptorBuilder();
        return builder.withName(aliasDescriptor.name()).withFullyQualifiedName(aliasDescriptor.fullyQualifiedName()).withParameters(originalDescriptor.parameters()).withAnnotatedReturnTypeName(originalDescriptor.annotatedReturnTypeName()).withDefinitionLocation(originalDescriptor.definitionLocation()).withHasDecorators(originalDescriptor.hasDecorators()).withTypeAnnotationDescriptor(originalDescriptor.typeAnnotationDescriptor()).withDecorators(originalDescriptor.decorators()).withIsAsynchronous(originalDescriptor.isAsynchronous()).withIsInstanceMethod(originalDescriptor.isInstanceMethod()).build();
    }

    private static ClassDescriptor recreateClassDescriptor(AliasDescriptor aliasDescriptor, ClassDescriptor originalDescriptor) {
        ClassDescriptor.ClassDescriptorBuilder builder = new ClassDescriptor.ClassDescriptorBuilder();
        return builder.withName(aliasDescriptor.name()).withFullyQualifiedName(aliasDescriptor.fullyQualifiedName()).withMembers(new HashSet<Descriptor>(originalDescriptor.members())).withSuperClasses(originalDescriptor.superClasses()).withDefinitionLocation(originalDescriptor.definitionLocation()).withHasMetaClass(originalDescriptor.hasMetaClass()).withHasSuperClassWithoutDescriptor(originalDescriptor.hasSuperClassWithoutDescriptor()).withMetaclassFQN(originalDescriptor.metaclassFQN()).withHasDecorators(originalDescriptor.hasDecorators()).withSupportsGenerics(originalDescriptor.supportsGenerics()).build();
    }

    private static ClassSymbolImpl createClassSymbol(Descriptor descriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolByFqn, String symbolName) {
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        ClassSymbolImpl classSymbol = new ClassSymbolImpl((ClassDescriptor)descriptor, symbolName);
        createdSymbolsByDescriptor.put(descriptor, classSymbol);
        createdSymbolByFqn.put(descriptor.fullyQualifiedName(), classSymbol);
        DescriptorUtils.addSuperClasses(classSymbol, classDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolByFqn);
        DescriptorUtils.addMembers(classSymbol, classDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolByFqn);
        return classSymbol;
    }

    private static void addMembers(ClassSymbolImpl classSymbol, ClassDescriptor classDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        classSymbol.addMembers(classDescriptor.members().stream().map(memberFqn -> DescriptorUtils.symbolFromDescriptor(memberFqn, projectLevelSymbolTable, null, createdSymbolsByDescriptor, createdSymbolsByFqn)).map(member -> {
            if (member instanceof FunctionSymbolImpl) {
                FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)member;
                functionSymbol.setOwner(classSymbol);
            }
            return member;
        }).toList());
    }

    private static void addSuperClasses(ClassSymbolImpl classSymbol, ClassDescriptor classDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        classDescriptor.superClasses().stream().map(superClassFqn -> {
            if (createdSymbolsByFqn.containsKey(superClassFqn)) {
                return (Symbol)createdSymbolsByFqn.get(superClassFqn);
            }
            Symbol symbol = projectLevelSymbolTable.getSymbol((String)superClassFqn, null, createdSymbolsByDescriptor, createdSymbolsByFqn);
            symbol = symbol != null ? symbol : SymbolUtils.typeshedSymbolWithFQN(superClassFqn);
            createdSymbolsByFqn.put((String)superClassFqn, symbol);
            return symbol;
        }).forEach(classSymbol::addSuperClass);
    }

    private static FunctionSymbolImpl createFunctionSymbol(FunctionDescriptor functionDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn, String symbolName) {
        FunctionSymbolImpl functionSymbol = new FunctionSymbolImpl(functionDescriptor, symbolName);
        DescriptorUtils.addParameters(functionSymbol, functionDescriptor, projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn);
        return functionSymbol;
    }

    private static void addParameters(FunctionSymbolImpl functionSymbol, FunctionDescriptor functionDescriptor, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        functionDescriptor.parameters().stream().map(parameterDescriptor -> {
            FunctionSymbolImpl.ParameterImpl parameter = new FunctionSymbolImpl.ParameterImpl((FunctionDescriptor.Parameter)parameterDescriptor);
            DescriptorUtils.setParameterType(parameter, parameterDescriptor.annotatedType(), projectLevelSymbolTable, createdSymbolsByDescriptor, createdSymbolsByFqn);
            return parameter;
        }).forEach(functionSymbol::addParameter);
    }

    private static void setParameterType(FunctionSymbolImpl.ParameterImpl parameter, String annotatedType, ProjectLevelSymbolTable projectLevelSymbolTable, Map<Descriptor, Symbol> createdSymbolsByDescriptor, Map<String, Symbol> createdSymbolsByFqn) {
        InferredType declaredType;
        if (parameter.isKeywordVariadic()) {
            declaredType = InferredTypes.DICT;
        } else if (parameter.isPositionalVariadic()) {
            declaredType = InferredTypes.TUPLE;
        } else {
            Symbol existingSymbol = createdSymbolsByFqn.get(annotatedType);
            Symbol typeSymbol = existingSymbol != null ? existingSymbol : projectLevelSymbolTable.getSymbol(annotatedType, null, createdSymbolsByDescriptor, createdSymbolsByFqn);
            String annotatedTypeName = parameter.annotatedTypeName();
            if (typeSymbol == null && annotatedTypeName != null) {
                typeSymbol = SymbolUtils.typeshedSymbolWithFQN(annotatedTypeName);
            }
            declaredType = typeSymbol == null ? InferredTypes.anyType() : new DeclaredType(typeSymbol, Collections.emptyList());
        }
        parameter.setDeclaredType(declaredType);
    }
}

