/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Tree;

public class ImportedNamesCollector
extends BaseTreeVisitor {
    private final Set<String> importedNames = new HashSet<String>();

    public void collect(Tree tree) {
        this.importedNames.clear();
        tree.accept(this);
    }

    @Override
    public void visitImportFrom(ImportFrom pyImportFromTree) {
        pyImportFromTree.importedNames().forEach(this::addImportedName);
    }

    @Override
    public void visitImportName(ImportName pyImportNameTree) {
        pyImportNameTree.modules().forEach(this::addImportedName);
    }

    private void addImportedName(AliasedName aliasedName) {
        Optional.of(aliasedName).map(AliasedName::alias).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).ifPresent(this.importedNames::add);
    }

    public boolean anyMatches(Predicate<String> predicate) {
        return this.importedNames.stream().anyMatch(predicate);
    }
}

