/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.callgraph.CallGraph;
import org.sonar.python.semantic.v2.callgraph.CallGraphWalker;
import org.sonar.python.tree.TreeUtils;

public class AwsLambdaChecksUtils {
    private AwsLambdaChecksUtils() {
    }

    public static boolean isLambdaHandlerInThisFile(SubscriptionContext ctx, Tree tree) {
        FileInput fileInput;
        FileInput root = null;
        root = tree instanceof FileInput ? (fileInput = (FileInput)tree) : TreeUtils.firstAncestorOfClass(tree, FileInput.class);
        FunctionDefCollector functionDefCollector = new FunctionDefCollector();
        root.accept(functionDefCollector);
        List<FunctionDef> functionDefs = functionDefCollector.getFunctionDefs();
        return functionDefs.stream().anyMatch(functionDef -> AwsLambdaChecksUtils.isLambdaHandler(ctx, functionDef));
    }

    public static boolean isLambdaHandler(SubscriptionContext ctx, FunctionDef functionDef) {
        return AwsLambdaChecksUtils.isLambdaHandler(ctx.projectConfiguration(), ctx.callGraph(), functionDef);
    }

    public static boolean isLambdaHandler(ProjectConfiguration config, CallGraph cg, FunctionDef functionDef) {
        PythonType pythonType = functionDef.name().typeV2();
        if (pythonType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)pythonType;
            String fqn = functionType.fullyQualifiedName();
            return AwsLambdaChecksUtils.isLambdaHandlerFqn(config, fqn) || AwsLambdaChecksUtils.isFqnCalledFromLambdaHandler(cg, config, fqn);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOnlyLambdaHandler(SubscriptionContext ctx, FunctionDef functionDef) {
        PythonType pythonType = functionDef.name().typeV2();
        if (!(pythonType instanceof FunctionType)) return false;
        FunctionType functionType = (FunctionType)pythonType;
        if (!AwsLambdaChecksUtils.isLambdaHandlerFqn(ctx.projectConfiguration(), functionType.fullyQualifiedName())) return false;
        return true;
    }

    private static boolean isLambdaHandlerFqn(ProjectConfiguration projectConfiguration, String fqn) {
        return projectConfiguration.awsProjectConfiguration().awsLambdaHandlers().stream().anyMatch(handler -> handler.fullyQualifiedName().equals(fqn));
    }

    private static boolean isFqnCalledFromLambdaHandler(CallGraph callGraph, ProjectConfiguration projectConfiguration, String fqn) {
        return new CallGraphWalker(callGraph).isUsedFrom(fqn, node -> AwsLambdaChecksUtils.isLambdaHandlerFqn(projectConfiguration, node.fqn())).isTrue();
    }

    private static class FunctionDefCollector
    extends BaseTreeVisitor {
        private final List<FunctionDef> functionDefs = new ArrayList<FunctionDef>();

        private FunctionDefCollector() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            this.functionDefs.add(functionDef);
            super.visitFunctionDef(functionDef);
        }

        public List<FunctionDef> getFunctionDefs() {
            return this.functionDefs;
        }
    }
}

