/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tests.UnittestUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5845")
public class AssertOnDissimilarTypesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this assertion to not compare dissimilar types";
    private static final String MESSAGE_SECONDARY = "Last assignment of \"%s\"";
    private static final Set<String> assertToCheckEquality = Set.of("assertEqual", "assertNotEqual");
    private static final Set<String> assertToCheckIdentity = Set.of("assertIs", "assertIsNot");
    private static final String FIRST_ARG_KEYWORD = "first";
    private static final String SECOND_ARG_KEYWORD = "second";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            Name qualifier;
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            if (!callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
                return;
            }
            QualifiedExpression qualifiedExpression = (QualifiedExpression)callExpression.callee();
            Expression patt2856$temp = qualifiedExpression.qualifier();
            if (!(patt2856$temp instanceof Name && "self".equals((qualifier = (Name)patt2856$temp).name()) && UnittestUtils.isWithinUnittestTestCase(qualifiedExpression))) {
                return;
            }
            AssertOnDissimilarTypesCheck.checkArguments(ctx, callExpression, qualifiedExpression);
        });
    }

    private static void checkArguments(SubscriptionContext ctx, CallExpression callExpression, QualifiedExpression qualifiedExpression) {
        Expression right;
        boolean isAnAssertIdentity = assertToCheckIdentity.contains(qualifiedExpression.name().name());
        boolean isAnAssertEquality = assertToCheckEquality.contains(qualifiedExpression.name().name());
        if (!isAnAssertEquality && !isAnAssertIdentity) {
            return;
        }
        ArgList args = callExpression.argumentList();
        if (args == null) {
            return;
        }
        List<Argument> arguments = args.arguments();
        RegularArgument firstArg = TreeUtils.nthArgumentOrKeyword(0, FIRST_ARG_KEYWORD, arguments);
        RegularArgument secondArg = TreeUtils.nthArgumentOrKeyword(1, SECOND_ARG_KEYWORD, arguments);
        if (firstArg == null || secondArg == null) {
            return;
        }
        Expression left = firstArg.expression();
        if (AssertOnDissimilarTypesCheck.canArgumentsBeIdentical(left, right = secondArg.expression())) {
            return;
        }
        if (isAnAssertIdentity || !AssertOnDissimilarTypesCheck.canArgumentsBeEqual(left, right)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(args, AssertOnDissimilarTypesCheck.message(left, right));
            AssertOnDissimilarTypesCheck.getLastAssignment(left).ifPresent(assign -> issue.secondary((Tree)assign, String.format(MESSAGE_SECONDARY, ((Name)left).name())));
            AssertOnDissimilarTypesCheck.getLastAssignment(right).ifPresent(assign -> issue.secondary((Tree)assign, String.format(MESSAGE_SECONDARY, ((Name)right).name())));
        }
    }

    private static String message(Expression left, Expression right) {
        String leftTypeName = InferredTypes.typeName(left.type());
        String rightTypeName = InferredTypes.typeName(right.type());
        Object message = MESSAGE;
        if (leftTypeName != null && rightTypeName != null) {
            message = (String)message + " (" + leftTypeName + " and " + rightTypeName + ")";
        }
        message = (String)message + ".";
        return message;
    }

    private static Optional<AssignmentStatement> getLastAssignment(Expression expr) {
        if (!expr.is(Tree.Kind.NAME)) {
            return Optional.empty();
        }
        Symbol symbol = ((Name)expr).symbol();
        if (symbol == null) {
            return Optional.empty();
        }
        Usage lastAssignment = symbol.usages().stream().sorted(Comparator.comparingInt(u -> u.tree().firstToken().line())).takeWhile(usage -> usage != ((Name)expr).usage()).filter(usage -> usage.kind() == Usage.Kind.ASSIGNMENT_LHS).reduce((first, second) -> second).orElse(null);
        return Optional.ofNullable(lastAssignment).map(assignment -> (AssignmentStatement)TreeUtils.firstAncestorOfKind(assignment.tree(), Tree.Kind.ASSIGNMENT_STMT));
    }

    private static boolean canArgumentsBeIdentical(Expression left, Expression right) {
        return left.type().isIdentityComparableWith(right.type()) || left.type().canOnlyBe("NoneType") || right.type().canOnlyBe("NoneType");
    }

    private static boolean canArgumentsBeEqual(Expression left, Expression right) {
        String leftCategory = InferredTypes.getBuiltinCategory(left.type());
        String rightCategory = InferredTypes.getBuiltinCategory(right.type());
        boolean leftCanImplementEqOrNe = AssertOnDissimilarTypesCheck.canImplementEqOrNe(left);
        boolean rightCanImplementEqOrNe = AssertOnDissimilarTypesCheck.canImplementEqOrNe(right);
        if (leftCategory != null && leftCategory.equals(rightCategory)) {
            return true;
        }
        return !(!leftCanImplementEqOrNe && !rightCanImplementEqOrNe || leftCategory != null && rightCategory != null || leftCategory != null && !rightCanImplementEqOrNe || rightCategory != null && !leftCanImplementEqOrNe);
    }

    private static boolean canImplementEqOrNe(Expression expression) {
        InferredType type = expression.type();
        return type.canHaveMember("__eq__") || type.canHaveMember("__ne__");
    }

    @Override
    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }
}

