/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tests.UnittestUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5915")
public class AssertAfterRaiseCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_MULTIPLE_STATEMENT = "Don\u2019t perform an assertion here; An exception is expected to be raised before its execution.";
    private static final String MESSAGE_SINGLE_STATEMENT = "Refactor this test; if this assertion\u2019s argument raises an exception, the assertion will never get executed.";
    private static final String MESSAGE_SECONDARY = "An exception is expected to be raised in this block.";
    private static final String ASSERTION_ERROR = "AssertionError";
    private static final String PYTEST_RAISE_CALL = "pytest.raises";
    private static final String PYTEST_ARG_EXCEPTION = "expected_exception";
    private static final String UNITTEST_ARG_EXCEPTION = "exception";
    public static final String QUICK_FIX_MESSAGE = "Change indentation level";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, ctx -> {
            WithStatement withStatement = (WithStatement)ctx.syntaxNode();
            if (!this.isWithStatementItemARaise(withStatement)) {
                return;
            }
            List<Statement> statements = withStatement.statements().statements();
            Statement statement = statements.get(statements.size() - 1);
            if (this.isAnAssert(statement)) {
                String message = statements.size() > 1 ? MESSAGE_MULTIPLE_STATEMENT : MESSAGE_SINGLE_STATEMENT;
                PythonCheck.PreciseIssue issue = ctx.addIssue(statement, message).secondary(IssueLocation.preciseLocation(withStatement.firstToken(), withStatement.colon(), MESSAGE_SECONDARY));
                if (statements.size() > 1) {
                    PythonQuickFix quickFix = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(AssertAfterRaiseCheck.createTextEdits(withStatement, statement)).build();
                    issue.addQuickFix(quickFix);
                }
            }
        });
    }

    private static List<PythonTextEdit> createTextEdits(WithStatement withStatement, Statement statement) {
        if (statement.firstToken().line() == withStatement.firstToken().line()) {
            String textToInsert = "\n" + " ".repeat(withStatement.firstToken().column());
            return List.of(TextEditUtils.insertBefore(statement, textToInsert));
        }
        int offset = statement.firstToken().column() - withStatement.firstToken().column();
        return TextEditUtils.shiftLeft(statement, offset);
    }

    public boolean isWithStatementItemARaise(WithStatement withStatement) {
        return withStatement.withItems().stream().filter(withItem -> withItem.test().is(Tree.Kind.CALL_EXPR)).map(withItem -> (CallExpression)withItem.test()).anyMatch(callExpression -> this.isValidPytestRaise((CallExpression)callExpression) || this.isValidUnittestRaise((CallExpression)callExpression));
    }

    public boolean isValidPytestRaise(CallExpression callExpression) {
        return Optional.of(callExpression).stream().map(call -> TreeUtils.getSymbolFromTree(call.callee())).filter(Optional::isPresent).map(Optional::get).map(Symbol::fullyQualifiedName).filter(Objects::nonNull).anyMatch(fqn -> fqn.contains(PYTEST_RAISE_CALL)) && this.isNotAssertionErrorArgument(TreeUtils.nthArgumentOrKeyword(0, PYTEST_ARG_EXCEPTION, callExpression.arguments()));
    }

    public boolean isValidUnittestRaise(CallExpression callExpression) {
        return Optional.of(callExpression).stream().filter(call -> call.callee().is(Tree.Kind.QUALIFIED_EXPR)).map(call -> (QualifiedExpression)call.callee()).anyMatch(callee -> {
            Name qualifier;
            Expression patt5238$temp = callee.qualifier();
            return patt5238$temp instanceof Name && "self".equals((qualifier = (Name)patt5238$temp).name()) && UnittestUtils.RAISE_METHODS.contains(callee.name().name());
        }) && this.isNotAssertionErrorArgument(TreeUtils.nthArgumentOrKeyword(0, UNITTEST_ARG_EXCEPTION, callExpression.arguments()));
    }

    public boolean isNotAssertionErrorArgument(RegularArgument regularArgument) {
        return Optional.ofNullable(regularArgument).stream().filter(Objects::nonNull).map(arg -> TreeUtils.getSymbolFromTree(arg.expression())).anyMatch(optSym -> optSym.isEmpty() || !ASSERTION_ERROR.equals(((Symbol)optSym.get()).fullyQualifiedName()));
    }

    public boolean isAnAssert(Statement statement) {
        if (statement.is(Tree.Kind.ASSERT_STMT)) {
            return true;
        }
        return Optional.of(statement).stream().filter(stat -> stat.is(Tree.Kind.EXPRESSION_STMT)).map(ExpressionStatement.class::cast).map(ExpressionStatement::expressions).anyMatch(expressions -> expressions.stream().filter(expression -> expression.is(Tree.Kind.CALL_EXPR)).map(expression -> ((CallExpression)expression).callee()).filter(callee -> callee.is(Tree.Kind.QUALIFIED_EXPR)).map(QualifiedExpression.class::cast).anyMatch(this::isUnittestAssert));
    }

    public boolean isUnittestAssert(QualifiedExpression callee) {
        Name qualifier;
        Expression expression = callee.qualifier();
        return expression instanceof Name && "self".equals((qualifier = (Name)expression).name()) && UnittestUtils.allAssertMethods().contains(callee.name().name());
    }
}

