/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterRangeTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;
import org.sonarsource.analyzer.commons.regex.ast.SimpleQuantifier;
import org.sonarsource.analyzer.commons.regex.finders.VerboseRegexFinder;

@Rule(key="S6353")
public class VerboseRegexCheck
extends AbstractRegexCheck {
    private static final String ISSUE_MESSAGE_PATTERN = ".+syntax '(.+)' instead of.+";
    private static final Pattern issueMessagePattern = Pattern.compile(".+syntax '(.+)' instead of.+");
    public static final String QUICK_FIX_FORMAT = "Replace with \"%s\"";
    public static final String REDUNDANT_RANGE_MESSAGE = "Use simple character '%s' instead of '%s'.";
    public static final String REDUNDANT_REPETITION_MESSAGE = "Use simple repetition '%s' instead of '%s'.";
    public static final String REDUNDANT_REPETITION_SECONDARY_LOCATION_MESSAGE = "The repeated element.";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        new VerboseRegexFinder(this::addIssueWithQuickFix).visit(regexParseResult);
        new PythonVerboseRegexRangeCheckVisitor().visit(regexParseResult);
        new PythonVerboseRegexRepetitionCheckVisitor().visit(regexParseResult);
    }

    public Optional<PythonCheck.PreciseIssue> addIssueWithQuickFix(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        return this.addIssue(regexTree, message, cost, secondaries).map(issue -> {
            Matcher matcher = issueMessagePattern.matcher(message);
            String quickFixReplacement = matcher.replaceFirst("$1");
            IssueLocation issueLocation = PythonRegexIssueLocation.preciseLocation(regexTree, null);
            PythonTextEdit textEdit = new PythonTextEdit(quickFixReplacement, issueLocation.startLine(), issueLocation.startLineOffset(), issueLocation.endLine(), issueLocation.endLineOffset());
            issue.addQuickFix(PythonQuickFix.newQuickFix(String.format(QUICK_FIX_FORMAT, quickFixReplacement), textEdit));
            return issue;
        });
    }

    private class PythonVerboseRegexRangeCheckVisitor
    extends RegexBaseVisitor {
        private PythonVerboseRegexRangeCheckVisitor() {
        }

        @Override
        public void visitCharacterRange(CharacterRangeTree tree) {
            String lower = tree.getLowerBound().getText();
            String upper = tree.getUpperBound().getText();
            if (upper.equals(lower)) {
                String quickFixReplacement = lower;
                IssueLocation issueLocation = PythonRegexIssueLocation.preciseLocation(tree, null);
                PythonTextEdit textEdit = new PythonTextEdit(quickFixReplacement, issueLocation.startLine(), issueLocation.startLineOffset(), issueLocation.endLine(), issueLocation.endLineOffset());
                VerboseRegexCheck.this.addIssue(tree, String.format(VerboseRegexCheck.REDUNDANT_RANGE_MESSAGE, quickFixReplacement, tree.getText()), null, Collections.emptyList()).ifPresent(issue -> issue.addQuickFix(PythonQuickFix.newQuickFix(String.format(VerboseRegexCheck.QUICK_FIX_FORMAT, quickFixReplacement), textEdit)));
            }
            super.visitCharacterRange(tree);
        }
    }

    private class PythonVerboseRegexRepetitionCheckVisitor
    extends RegexBaseVisitor {
        private PythonVerboseRegexRepetitionCheckVisitor() {
        }

        @Override
        public void visit(RegexTree tree) {
            tree.continuation().toRegexTree().filter(nextTree -> nextTree.is(RegexTree.Kind.REPETITION)).filter(RepetitionTree.class::isInstance).map(RepetitionTree.class::cast).filter(repetition -> repetition.getQuantifier() instanceof SimpleQuantifier).filter(repetition -> ((SimpleQuantifier)repetition.getQuantifier()).getKind() == SimpleQuantifier.Kind.STAR).filter(repetition -> repetition.getQuantifier().getModifier() == Quantifier.Modifier.GREEDY).filter(repetition -> repetition.getRange().getBeginningOffset() > tree.getRange().getBeginningOffset()).ifPresent(repetition -> {
                String nextTreeText;
                String treeText = tree.getText();
                if (treeText.equals(nextTreeText = repetition.getElement().getText())) {
                    IssueLocation repetitionLocation = PythonRegexIssueLocation.preciseLocation(repetition, null);
                    String quickFixReplacement = "+";
                    PythonTextEdit textEdit = new PythonTextEdit(quickFixReplacement, repetitionLocation.startLine(), repetitionLocation.startLineOffset(), repetitionLocation.endLine(), repetitionLocation.endLineOffset());
                    String issueMessage = String.format(VerboseRegexCheck.REDUNDANT_REPETITION_MESSAGE, treeText + quickFixReplacement, treeText + repetition.getText());
                    VerboseRegexCheck.this.addIssue((RegexSyntaxElement)repetition, issueMessage, null, List.of(new RegexIssueLocation(tree, VerboseRegexCheck.REDUNDANT_REPETITION_SECONDARY_LOCATION_MESSAGE))).ifPresent(issue -> issue.addQuickFix(PythonQuickFix.newQuickFix(String.format(VerboseRegexCheck.QUICK_FIX_FORMAT, quickFixReplacement), textEdit)));
                }
            });
            super.visit(tree);
        }
    }
}

