/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonar.python.regex.PythonRegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.finders.SingleCharCharacterClassFinder;

@Rule(key="S6397")
public class SingleCharCharacterClassCheck
extends AbstractRegexCheck {
    public static final String QUICK_FIX_MESSAGE = "Replace this character class with the character itself";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        Optional.ofNullable(regexFunctionCall.calleeSymbol()).flatMap(symbol -> Optional.ofNullable(symbol.fullyQualifiedName())).filter(fqn -> this.lookedUpFunctions().containsKey(fqn)).filter(fqn -> !regexParseResult.getResult().activeFlags().contains(4)).ifPresent(fqn -> new SingleCharCharacterClassFinder(this::addIssue).visit(regexParseResult));
    }

    @Override
    public Optional<PythonCheck.PreciseIssue> addIssue(RegexSyntaxElement regexTree, String message, @Nullable Integer cost, List<RegexIssueLocation> secondaries) {
        return super.addIssue(regexTree, message, cost, secondaries).map(issue -> {
            String quickFixReplacement = regexTree.getText();
            IssueLocation issueLocation = PythonRegexIssueLocation.preciseLocation(regexTree, null);
            PythonTextEdit textEdit = new PythonTextEdit(quickFixReplacement, issueLocation.startLine(), issueLocation.startLineOffset() - 1, issueLocation.endLine(), issueLocation.endLineOffset() + 1);
            issue.addQuickFix(PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE, textEdit));
            return issue;
        });
    }
}

