/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.checks.hotspots.CommonValidationUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S6377")
public class XMLSignatureValidationCheck
extends PythonSubscriptionCheck {
    private static final List<String> VERIFY_REQUIRED_ONE_OF = List.of("x509_cert", "cert_subject_name", "cert_resolver", "ca_pem_file", "ca_path", "hmac_key");
    private static final String MESSAGE = "Change this code to only accept signatures computed from a trusted party.";
    private static final String MESSAGE_SECONDARY = "Unsafe parameter set here";
    private TypeCheckBuilder xmlVerifierVerifyTypeChecker;
    private TypeCheckBuilder dictTypeChecker;
    private TypeCheckBuilder signatureConfigurationTypeChecker;
    private TypeCheckMap<Boolean> signatureMethodTypeCheckMap;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::registerTypeCheckers);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpr);
    }

    private void registerTypeCheckers(SubscriptionContext subscriptionContext) {
        this.xmlVerifierVerifyTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.XMLVerifier");
        this.dictTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithName("dict");
        this.signatureConfigurationTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.SignatureConfiguration");
        this.signatureMethodTypeCheckMap = TypeCheckMap.ofEntries(Map.entry(subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.SignatureMethod.HMAC_SHA224"), true), Map.entry(subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.SignatureMethod.HMAC_SHA256"), true), Map.entry(subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.SignatureMethod.HMAC_SHA384"), true), Map.entry(subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("signxml.SignatureMethod.HMAC_SHA512"), true));
    }

    private void checkCallExpr(SubscriptionContext subscriptionContext) {
        Tree expectConfigValue;
        CallExpression callExpression = (CallExpression)subscriptionContext.syntaxNode();
        QualifiedExpression qualifiedExprCallee = Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).orElse(null);
        if (qualifiedExprCallee == null) {
            return;
        }
        boolean ok = this.qualifiedExpressionIsVerifyCall(qualifiedExprCallee);
        if (!ok) {
            return;
        }
        HashMap<String, Expression> argToTree = new HashMap<String, Expression>();
        for (Argument arg : callExpression.arguments()) {
            if (arg instanceof RegularArgument) {
                RegularArgument regularArgument = (RegularArgument)arg;
                String argumentName = Optional.ofNullable(regularArgument.keywordArgument()).map(Name::name).orElse("");
                argToTree.put(argumentName, regularArgument.expression());
                continue;
            }
            Map keys = TreeUtils.toOptionalInstanceOf(UnpackingExpression.class, arg).map(UnpackingExpression::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).flatMap(Expressions::singleAssignedNonNameValue).map(this::keysInUnpacking).orElseGet(Map::of);
            argToTree.putAll(keys);
        }
        if (Collections.disjoint(argToTree.keySet(), VERIFY_REQUIRED_ONE_OF)) {
            subscriptionContext.addIssue(callExpression.callee(), MESSAGE);
        }
        if ((expectConfigValue = (Tree)argToTree.get("expect_config")) != null) {
            this.checkExpectConfig(subscriptionContext, expectConfigValue, callExpression);
        }
    }

    private void checkExpectConfig(SubscriptionContext subscriptionContext, Tree expectConfigValue, CallExpression verifyCallExpression) {
        CallExpression callExpression;
        if ((expectConfigValue = XMLSignatureValidationCheck.replaceBySingleAssigned(expectConfigValue)) instanceof CallExpression && this.signatureConfigurationTypeChecker.check((callExpression = (CallExpression)expectConfigValue).callee().typeV2()) == TriBool.TRUE) {
            TreeUtils.nthArgumentOrKeywordOptional(0, "require_x509", callExpression.arguments()).filter(arg -> Expressions.isFalsy(arg.expression())).ifPresent(arg -> subscriptionContext.addIssue(verifyCallExpression, MESSAGE).secondary((Tree)arg, MESSAGE_SECONDARY));
            TreeUtils.nthArgumentOrKeywordOptional(3, "signature_methods", callExpression.arguments()).map(this::getOffendingInList).filter(list -> !list.isEmpty()).ifPresent(list -> {
                PythonCheck.PreciseIssue issue = subscriptionContext.addIssue(verifyCallExpression, MESSAGE);
                list.forEach(secondary -> issue.secondary((Tree)secondary, MESSAGE_SECONDARY));
            });
        }
    }

    private static Tree replaceBySingleAssigned(Tree expectConfigValue) {
        if (expectConfigValue.is(Tree.Kind.NAME)) {
            expectConfigValue = Expressions.singleAssignedNonNameValue((Name)expectConfigValue).orElse(null);
        }
        return expectConfigValue;
    }

    private List<Expression> getOffendingInList(RegularArgument regularArgument) {
        Tree expression = XMLSignatureValidationCheck.replaceBySingleAssigned(regularArgument.expression());
        return TreeUtils.toOptionalInstanceOf(ListLiteral.class, expression).map(ListLiteral::elements).map(ExpressionList::expressions).stream().flatMap(Collection::stream).filter(e -> this.signatureMethodTypeCheckMap.getOptionalForType(e.typeV2()).isEmpty()).toList();
    }

    private Map<String, Tree> keysInUnpacking(Expression expression) {
        CallExpression callExpression;
        if (expression instanceof CallExpression && this.dictTypeChecker.check((callExpression = (CallExpression)expression).callee().typeV2()) == TriBool.TRUE) {
            return callExpression.arguments().stream().flatMap(TreeUtils.toStreamInstanceOfMapper(RegularArgument.class)).filter(regularArgument -> regularArgument.keywordArgument() != null).collect(Collectors.toMap(regularArgument -> regularArgument.keywordArgument().name(), RegularArgument::expression));
        }
        if (expression instanceof DictionaryLiteral) {
            DictionaryLiteral dictionaryLiteral = (DictionaryLiteral)expression;
            HashMap<String, Tree> output = new HashMap<String, Tree>();
            for (DictionaryLiteralElement element : dictionaryLiteral.elements()) {
                if (element instanceof KeyValuePair) {
                    KeyValuePair keyValuePair = (KeyValuePair)element;
                    String key = CommonValidationUtils.singleAssignedString(keyValuePair.key());
                    if (key.isEmpty()) continue;
                    output.put(key, keyValuePair.value());
                    continue;
                }
                Map unpackedKeys = TreeUtils.toOptionalInstanceOf(UnpackingExpression.class, element).map(UnpackingExpression::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).flatMap(Expressions::singleAssignedNonNameValue).map(this::keysInUnpacking).orElseGet(Map::of);
                output.putAll(unpackedKeys);
            }
            return output;
        }
        return Map.of();
    }

    private boolean qualifiedExpressionIsVerifyCall(QualifiedExpression qualifiedExprCallee) {
        Expression expression = qualifiedExprCallee.qualifier();
        if (expression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)expression;
            return this.xmlVerifierVerifyTypeChecker.check(callExpression.callee().typeV2()) == TriBool.TRUE;
        }
        expression = qualifiedExprCallee.qualifier();
        if (expression instanceof Name) {
            Name name = (Name)expression;
            return this.xmlVerifierVerifyTypeChecker.check(name.typeV2()) == TriBool.TRUE;
        }
        return false;
    }
}

