/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3752")
public class UnsafeHttpMethodsCheck
extends PythonSubscriptionCheck {
    private static final Set<String> SAFE_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS"));
    private static final Set<String> UNSAFE_HTTP_METHODS = new HashSet<String>(Arrays.asList("POST", "PUT", "DELETE"));
    private static final Set<String> COMPLIANT_DECORATORS = new HashSet<String>(Arrays.asList("django.views.decorators.http.require_POST", "django.views.decorators.http.require_GET", "django.views.decorators.http.require_safe"));
    private static final String MESSAGE = "Make sure allowing safe and unsafe HTTP methods is safe here.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (UnsafeHttpMethodsCheck.isDjangoView(functionDef)) {
                UnsafeHttpMethodsCheck.checkDjangoView(functionDef, ctx);
            } else {
                UnsafeHttpMethodsCheck.getFlaskViewDecorator(functionDef).ifPresent(callExpression -> UnsafeHttpMethodsCheck.checkFlaskView(callExpression, ctx));
            }
        });
    }

    private static void checkDjangoView(FunctionDef functionDef, SubscriptionContext ctx) {
        for (Decorator decorator : functionDef.decorators()) {
            CallExpression callExpression;
            Symbol symbol2;
            if (TreeUtils.getSymbolFromTree(decorator.expression()).filter(symbol -> symbol.fullyQualifiedName() == null || COMPLIANT_DECORATORS.contains(symbol.fullyQualifiedName())).isPresent()) {
                return;
            }
            if (!decorator.expression().is(Tree.Kind.CALL_EXPR) || (symbol2 = (callExpression = (CallExpression)decorator.expression()).calleeSymbol()) == null || !"django.views.decorators.http.require_http_methods".equals(symbol2.fullyQualifiedName())) continue;
            UnsafeHttpMethodsCheck.checkRequireHttpMethodsDecorator(ctx, callExpression);
            return;
        }
        ctx.addIssue(functionDef.name(), MESSAGE);
    }

    private static void checkRequireHttpMethodsDecorator(SubscriptionContext ctx, CallExpression callExpression) {
        List<Argument> arguments = callExpression.arguments();
        if (!arguments.isEmpty() && UnsafeHttpMethodsCheck.hasBothUnsafeAndSafeHttpMethods(arguments.get(0))) {
            ctx.addIssue(callExpression, MESSAGE);
        }
    }

    private static boolean hasBothUnsafeAndSafeHttpMethods(Argument argument) {
        boolean hasSafeHttpMethod = false;
        boolean hasUnsafeHttpMethod = false;
        if (argument.is(Tree.Kind.REGULAR_ARGUMENT) && ((RegularArgument)argument).expression().is(Tree.Kind.LIST_LITERAL)) {
            ListLiteral listLiteral = (ListLiteral)((RegularArgument)argument).expression();
            for (Expression expression : listLiteral.elements().expressions()) {
                if (!expression.is(Tree.Kind.STRING_LITERAL)) continue;
                String value = ((StringLiteral)expression).trimmedQuotesValue();
                if (SAFE_HTTP_METHODS.contains(value)) {
                    hasSafeHttpMethod = true;
                    continue;
                }
                if (!UNSAFE_HTTP_METHODS.contains(value)) continue;
                hasUnsafeHttpMethod = true;
            }
        }
        return hasSafeHttpMethod && hasUnsafeHttpMethod;
    }

    private static boolean isDjangoView(FunctionDef functionDef) {
        FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
        return Optional.ofNullable(functionSymbol).map(FunctionSymbolImpl.class::cast).filter(FunctionSymbolImpl::isDjangoView).isPresent();
    }

    private static Optional<CallExpression> getFlaskViewDecorator(FunctionDef functionDef) {
        return functionDef.decorators().stream().map(Decorator::expression).filter(expression -> expression.is(Tree.Kind.CALL_EXPR)).map(CallExpression.class::cast).filter(UnsafeHttpMethodsCheck::isFlaskRouteDecorator).findFirst();
    }

    private static boolean isFlaskRouteDecorator(CallExpression callExpression) {
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return false;
        }
        return "route".equals(calleeSymbol.name());
    }

    private static void checkFlaskView(CallExpression callExpression, SubscriptionContext ctx) {
        RegularArgument methodsArg = TreeUtils.argumentByKeyword("methods", callExpression.arguments());
        if (methodsArg != null && UnsafeHttpMethodsCheck.hasBothUnsafeAndSafeHttpMethods(methodsArg) && UnsafeHttpMethodsCheck.isFlaskImported(callExpression)) {
            ctx.addIssue(callExpression, MESSAGE);
        }
    }

    private static boolean isFlaskImported(CallExpression callExpression) {
        return Optional.ofNullable(TreeUtils.firstAncestorOfKind(callExpression, Tree.Kind.FILE_INPUT)).filter(fileInput -> ((FileInput)fileInput).globalVariables().stream().map(Symbol::fullyQualifiedName).filter(Objects::nonNull).anyMatch(fqn -> fqn.contains("flask"))).isPresent();
    }
}

