/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S2077")
public class SQLQueriesCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S2077";
    private static final String MESSAGE = "Make sure that formatting this SQL query is safe here.";
    private boolean isUsingDjangoModel = false;
    private boolean isUsingDjangoDBConnection = false;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::visitFile);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void visitFile(SubscriptionContext ctx) {
        this.isUsingDjangoModel = false;
        this.isUsingDjangoDBConnection = false;
        FileInput tree = (FileInput)ctx.syntaxNode();
        SymbolsFromImport visitor = new SymbolsFromImport();
        tree.accept(visitor);
        visitor.symbols.stream().filter(Objects::nonNull).map(Symbol::fullyQualifiedName).filter(Objects::nonNull).forEach(qualifiedName -> {
            if (qualifiedName.contains("django.db.models")) {
                this.isUsingDjangoModel = true;
            }
            if (qualifiedName.contains("django.db.connection")) {
                this.isUsingDjangoDBConnection = true;
            }
        });
    }

    private boolean isSQLQueryFromDjangoModel(String functionName) {
        return this.isUsingDjangoModel && ("raw".equals(functionName) || "extra".equals(functionName));
    }

    private boolean isSQLQueryFromDjangoDBConnection(String functionName) {
        return this.isUsingDjangoDBConnection && "execute".equals(functionName);
    }

    private void checkCallExpression(SubscriptionContext context) {
        String functionName;
        CallExpression callExpression = (CallExpression)context.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (symbol != null && "django.db.models.expressions.RawSQL".equals(symbol.fullyQualifiedName())) {
            SQLQueriesCheck.addIssue(context, callExpression);
            return;
        }
        if (callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR) && (this.isSQLQueryFromDjangoModel(functionName = ((QualifiedExpression)callExpression.callee()).name().name()) || this.isSQLQueryFromDjangoDBConnection(functionName)) && !SQLQueriesCheck.isException(callExpression, functionName)) {
            SQLQueriesCheck.addIssue(context, callExpression);
        }
    }

    private static void addIssue(SubscriptionContext context, CallExpression callExpression) {
        Optional<Tree> secondary = SQLQueriesCheck.sensitiveArgumentValue(callExpression);
        secondary.ifPresent(tree -> context.addIssue(callExpression, MESSAGE).secondary((Tree)tree, null));
    }

    private static boolean isException(CallExpression callExpression, String functionName) {
        List<Argument> argListNode = callExpression.arguments();
        if (SQLQueriesCheck.extraContainsFormattedSqlQueries(argListNode, functionName)) {
            return false;
        }
        return argListNode.isEmpty();
    }

    private static Optional<Tree> sensitiveArgumentValue(CallExpression callExpression) {
        List<Argument> argListNode = callExpression.arguments();
        if (argListNode.isEmpty()) {
            return Optional.empty();
        }
        Argument arg = argListNode.get(0);
        if (!arg.is(Tree.Kind.REGULAR_ARGUMENT)) {
            return Optional.empty();
        }
        Expression expression = SQLQueriesCheck.getExpression(((RegularArgument)arg).expression());
        if (expression.is(Tree.Kind.NAME)) {
            expression = Expressions.singleAssignedValue((Name)expression);
        }
        if (expression != null && SQLQueriesCheck.isFormatted(expression)) {
            return Optional.of(expression);
        }
        return Optional.empty();
    }

    private static boolean isFormatted(Expression tree) {
        FormattedStringVisitor visitor = new FormattedStringVisitor();
        tree.accept(visitor);
        return visitor.hasFormattedString;
    }

    private static boolean extraContainsFormattedSqlQueries(List<Argument> argListNode, String functionName) {
        if ("extra".equals(functionName)) {
            return argListNode.stream().filter(arg -> arg.is(Tree.Kind.REGULAR_ARGUMENT)).map(RegularArgument.class::cast).filter(SQLQueriesCheck::isAssignment).map(RegularArgument::expression).anyMatch(SQLQueriesCheck::isFormatted);
        }
        return false;
    }

    private static boolean isAssignment(RegularArgument arg) {
        return arg.equalToken() != null;
    }

    private static Expression getExpression(Expression expr) {
        expr = Expressions.removeParentheses(expr);
        if (expr.is(Tree.Kind.ASSIGNMENT_EXPRESSION)) {
            return SQLQueriesCheck.getExpression(((AssignmentExpression)expr).expression());
        }
        return expr;
    }

    private static class SymbolsFromImport
    extends BaseTreeVisitor {
        private Set<Symbol> symbols = new HashSet<Symbol>();

        private SymbolsFromImport() {
        }

        @Override
        public void visitAliasedName(AliasedName aliasedName) {
            List<Name> names = aliasedName.dottedName().names();
            this.symbols.add(names.get(names.size() - 1).symbol());
        }
    }

    private static class FormattedStringVisitor
    extends BaseTreeVisitor {
        boolean hasFormattedString = false;

        private FormattedStringVisitor() {
        }

        @Override
        public void visitStringElement(StringElement stringElement) {
            super.visitStringElement(stringElement);
            this.hasFormattedString |= stringElement.isInterpolated();
        }

        @Override
        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            if (pyCallExpressionTree.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
                QualifiedExpression callee = (QualifiedExpression)pyCallExpressionTree.callee();
                this.hasFormattedString |= "format".equals(callee.name().name()) && callee.qualifier().is(Tree.Kind.STRING_LITERAL);
            }
            super.visitCallExpression(pyCallExpressionTree);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
            this.hasFormattedString |= pyBinaryExpressionTree.leftOperand().is(Tree.Kind.STRING_LITERAL) || pyBinaryExpressionTree.rightOperand().is(Tree.Kind.STRING_LITERAL);
            super.visitBinaryExpression(pyBinaryExpressionTree);
        }
    }
}

