/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentExpression;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;

@Rule(key="S4784")
public class RegexCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S4784";
    private static final String MESSAGE = "Make sure that using a regular expression is safe here.";
    private static final int REGEX_ARGUMENT = 0;
    private static final Set<String> questionableFunctions = new HashSet<String>(Arrays.asList("django.core.validators.RegexValidator", "django.urls.conf.re_path", "re.compile", "re.match", "re.search", "re.fullmatch", "re.split", "re.findall", "re.finditer", "re.sub", "re.subn", "regex.compile", "regex.match", "regex.search", "regex.fullmatch", "regex.split", "regex.findall", "regex.finditer", "regex.sub", "regex.subn", "regex.subf", "regex.subfn", "regex.splititer"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression call = (CallExpression)ctx.syntaxNode();
            Symbol symbol = call.calleeSymbol();
            if (symbol != null && questionableFunctions.contains(symbol.fullyQualifiedName()) && !call.arguments().isEmpty()) {
                RegexCheck.checkRegexArgument(call.arguments().get(0), ctx);
            }
        });
    }

    private static void checkRegexArgument(Argument arg, SubscriptionContext ctx) {
        String literal = null;
        IssueLocation secondaryLocation = null;
        if (!arg.is(Tree.Kind.REGULAR_ARGUMENT)) {
            return;
        }
        Expression argExpression = RegexCheck.getExpression(((RegularArgument)arg).expression());
        if (argExpression.is(Tree.Kind.NAME)) {
            Expression expression = RegexCheck.getExpression(Expressions.singleAssignedValue((Name)argExpression));
            if (expression != null && expression.is(Tree.Kind.STRING_LITERAL)) {
                secondaryLocation = IssueLocation.preciseLocation(expression, "");
                literal = Expressions.unescape((StringLiteral)expression);
            }
        } else if (argExpression.is(Tree.Kind.STRING_LITERAL)) {
            literal = Expressions.unescape((StringLiteral)argExpression);
        }
        if (literal == null) {
            return;
        }
        if (RegexCheck.isSuspiciousRegex(literal)) {
            PythonCheck.PreciseIssue preciseIssue = ctx.addIssue(arg, MESSAGE);
            if (secondaryLocation != null) {
                preciseIssue.secondary(secondaryLocation);
            }
        }
    }

    private static Expression getExpression(@Nullable Expression expr) {
        if (expr == null) {
            return null;
        }
        if ((expr = Expressions.removeParentheses(expr)).is(Tree.Kind.MODULO) || expr.is(Tree.Kind.PLUS)) {
            return RegexCheck.getExpression(((BinaryExpression)expr).leftOperand());
        }
        if (expr.is(Tree.Kind.ASSIGNMENT_EXPRESSION)) {
            return RegexCheck.getExpression(((AssignmentExpression)expr).expression());
        }
        return expr;
    }

    private static boolean isSuspiciousRegex(String regexp) {
        if (regexp.length() > 2) {
            int nOfSuspiciousChars = regexp.length() - regexp.replaceAll("[*+{]", "").length();
            return nOfSuspiciousChars > 1;
        }
        return false;
    }
}

