/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.hotspots.CommonValidationUtils;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S5344")
public class FastHashingOrPlainTextCheck
extends PythonSubscriptionCheck {
    private static final String SCRYPT_PARAMETERS_MESSAGE = "Use strong scrypt parameters.";
    private static final String PBKDF2_MESSAGE = "Use at least 100 000 iterations.";
    private static final String ARGON2_MESSAGE = "Use secure Argon2 parameters.";
    private static final String BCRYPT_MESSAGE = "Use strong bcrypt parameters.";
    private static final String DJANGO_MESSAGE = "Use a secure hashing algorithm to store passwords.";
    private static final Set<String> PBKDF2_ALGOS = Set.of("sha1", "sha256", "sha512");
    private static final String ROUNDS = "rounds";
    private static final Set<String> DJANGO_FIRST_FORBIDDEN_HASHERS = Set.of("django.contrib.auth.hashers.SHA1PasswordHasher", "django.contrib.auth.hashers.MD5PasswordHasher", "django.contrib.auth.hashers.UnsaltedSHA1PasswordHasher", "django.contrib.auth.hashers.UnsaltedMD5PasswordHasher", "django.contrib.auth.hashers.CryptPasswordHasher");
    private static final CommonValidationUtils.ArgumentValidator SCRYPT_R = new CommonValidationUtils.ArgumentValidator(3, "r", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 8)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator SCRYPT_BUFLEN = new CommonValidationUtils.ArgumentValidator(5, "buflen", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 32)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator SCRYPT_N = new CommonValidationUtils.ArgumentValidator(2, "N", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), (int)Math.pow(2.0, 13.0)) || CommonValidationUtils.isLessThanExponent(argument.expression(), 13)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator HASHLIB_R = new CommonValidationUtils.ArgumentValidator(3, "r", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 8)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator HASHLIB_N = new CommonValidationUtils.ArgumentValidator(2, "n", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), (int)Math.pow(2.0, 13.0)) || CommonValidationUtils.isLessThanExponent(argument.expression(), 13)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator HASHLIB_DKLEN = new CommonValidationUtils.ArgumentValidator(6, "dklen", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 32)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator CRYPTOGRAPHY_R = new CommonValidationUtils.ArgumentValidator(3, "r", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 8)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator CRYPTOGRAPHY_N = new CommonValidationUtils.ArgumentValidator(2, "n", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), (int)Math.pow(2.0, 13.0)) || CommonValidationUtils.isLessThanExponent(argument.expression(), 13)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator CRYPTOGRAPHY_LENGTH = new CommonValidationUtils.ArgumentValidator(1, "length", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 32)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator PASSLIB_BLOCK_SIZE = new CommonValidationUtils.ArgumentValidator(3, "block_size", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 8)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator PASSLIB_ROUNDS = new CommonValidationUtils.ArgumentValidator(2, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 12)) {
            ctx.addIssue((Tree)argument, SCRYPT_PARAMETERS_MESSAGE);
        }
    });
    private static final CommonValidationUtils.ArgumentValidator PASSLIB_PBKDF2 = new CommonValidationUtils.ArgumentValidator(2, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 100000)) {
            ctx.addIssue((Tree)argument, PBKDF2_MESSAGE);
        }
    });
    private static final CommonValidationUtils.CallValidator CRYPTOGRAPHY_PBKDF2 = new PBKDF2Validator(0, "algorithm", 3, "iterations");
    private static final CommonValidationUtils.CallValidator HASHLIB_PBKDF2 = new PBKDF2Validator(0, "hash_name", 3, "iterations");
    private static final CommonValidationUtils.CallValidator PASSLIB_MISSING_ROUNDS = new MissingArgumentValidator(2, "rounds", "Use at least 100 000 iterations.");
    private static final CommonValidationUtils.CallValidator BCRYPT_GENSALT = new CommonValidationUtils.ArgumentValidator(0, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 12)) {
            ctx.addIssue((Tree)argument, BCRYPT_MESSAGE);
        }
    });
    private static final CommonValidationUtils.CallValidator BCRYPT_KDF = new CommonValidationUtils.ArgumentValidator(3, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 4096) || CommonValidationUtils.isLessThanExponent(argument.expression(), 12)) {
            ctx.addIssue((Tree)argument, BCRYPT_MESSAGE);
        }
    });
    private static final CommonValidationUtils.CallValidator PASSLIB_BCRYPT = new CommonValidationUtils.ArgumentValidator(3, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 12)) {
            ctx.addIssue((Tree)argument, BCRYPT_MESSAGE);
        }
    });
    private static final CommonValidationUtils.CallValidator FLASK_BCRYPT = new CommonValidationUtils.ArgumentValidator(1, "rounds", (ctx, argument) -> {
        if (CommonValidationUtils.isLessThan(argument.expression(), 12)) {
            ctx.addIssue((Tree)argument, BCRYPT_MESSAGE);
        }
    });
    private TypeCheckBuilder argon2IDTypeChecker = null;
    private final CommonValidationUtils.CallValidator argon2Type = new CommonValidationUtils.ArgumentValidator(0, "type", (ctx, argument) -> {
        if (this.argon2IDTypeChecker.check(argument.expression().typeV2()) == TriBool.FALSE) {
            ctx.addIssue((Tree)argument, "Use Argon2ID to improve the security of the passwords.");
        }
    });
    private TypeCheckBuilder argon2VersionTypeChecker = null;
    private final CommonValidationUtils.CallValidator argon2Version = new CommonValidationUtils.ArgumentValidator(1, "version", (ctx, argument) -> {
        TriBool typeCheck = this.argon2VersionTypeChecker.check(argument.expression().typeV2());
        if (typeCheck == TriBool.TRUE) {
            return;
        }
        if (!CommonValidationUtils.isEqualTo(argument.expression(), 19)) {
            ctx.addIssue((Tree)argument, "Use the latest version of Argon2 ID.");
        }
    });
    private final Map<String, Collection<CommonValidationUtils.CallValidator>> callExpressionValidators = Map.ofEntries(Map.entry("scrypt.hash", List.of(SCRYPT_R, SCRYPT_BUFLEN, SCRYPT_N)), Map.entry("hashlib.scrypt", List.of(HASHLIB_R, HASHLIB_N, HASHLIB_DKLEN)), Map.entry("hashlib.pbkdf2_hmac", List.of(HASHLIB_PBKDF2)), Map.entry("cryptography.hazmat.primitives.kdf.scrypt.Scrypt", List.of(CRYPTOGRAPHY_R, CRYPTOGRAPHY_N, CRYPTOGRAPHY_LENGTH)), Map.entry("cryptography.hazmat.primitives.kdf.pbkdf2.PBKDF2HMAC", List.of(CRYPTOGRAPHY_PBKDF2)), Map.entry("passlib.handlers.scrypt.scrypt.using", List.of(PASSLIB_BLOCK_SIZE, PASSLIB_ROUNDS)), Map.entry("argon2.PasswordHasher", List.of(new Argon2PasswordHasherValidator(0, 1, 2))), Map.entry("argon2.Parameters", List.of(new Argon2PasswordHasherValidator(4, 5, 6), this.argon2Type, this.argon2Version)), Map.entry("argon2.low_level.hash_secret", List.of(new Argon2PasswordHasherValidator(2, 3, 4))), Map.entry("argon2.low_level.hash_secret_raw", List.of(new Argon2PasswordHasherValidator(2, 3, 4))), Map.entry("passlib.handlers.argon2._Argon2Common.using", List.of(new Argon2PasswordHasherValidator(3, 4, 5))), Map.entry("bcrypt.gensalt", List.of(BCRYPT_GENSALT)), Map.entry("bcrypt.kdf", List.of(BCRYPT_KDF)), Map.entry("flask_bcrypt.generate_password_hash", List.of(FLASK_BCRYPT)));
    private static final Map<String, Collection<CommonValidationUtils.CallValidator>> CALL_EXPRESSION_VALIDATORS_V1 = Map.ofEntries(Map.entry("flask_bcrypt.Bcrypt.generate_password_hash", List.of(FLASK_BCRYPT)));
    private static final Map<String, Collection<CommonValidationUtils.CallValidator>> QUALIFIED_EXPR_VALIDATOR = Map.of("passlib.hash.pbkdf2_sha1.using", List.of(PASSLIB_PBKDF2), "passlib.hash.pbkdf2_sha256.using", List.of(PASSLIB_PBKDF2, PASSLIB_MISSING_ROUNDS), "passlib.hash.pbkdf2_sha512.using", List.of(PASSLIB_PBKDF2, PASSLIB_MISSING_ROUNDS), "passlib.hash.bcrypt.using", List.of(PASSLIB_BCRYPT));
    private TypeCheckBuilder argon2CheapestProfileTypeChecker = null;
    private TypeCheckBuilder flaskConfigTypeChecker = null;
    private TypeCheckMap<Collection<CommonValidationUtils.CallValidator>> typeCheckMap = null;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::registerTypeCheckers);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, subscriptionContext1 -> {
            if (!"settings.py".equals(subscriptionContext1.pythonFile().fileName())) {
                return;
            }
            context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, FastHashingOrPlainTextCheck::checkDjangoHasher);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpr);
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, this::checkName);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, subscriptionContext -> FastHashingOrPlainTextCheck.checkAssignment(subscriptionContext, this.flaskConfigTypeChecker));
    }

    private static void checkDjangoHasher(SubscriptionContext subscriptionContext) {
        AssignmentStatement stmt = (AssignmentStatement)subscriptionContext.syntaxNode();
        Optional<Expression> lhsIsConfig = stmt.lhsExpressions().stream().findFirst().map(ExpressionList::expressions).flatMap(list -> list.stream().findFirst()).filter(expression -> expression.is(Tree.Kind.NAME)).filter(name -> "PASSWORD_HASHERS".equals(((Name)name).name()));
        Optional<StringLiteral> firstRhsString = Optional.of(stmt.assignedValue()).flatMap(TreeUtils.toOptionalInstanceOfMapper(ListLiteral.class)).map(ListLiteral::elements).map(ExpressionList::expressions).map(Collection::stream).flatMap(Stream::findFirst).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).filter(stringLiteral -> DJANGO_FIRST_FORBIDDEN_HASHERS.contains(stringLiteral.trimmedQuotesValue()));
        if (lhsIsConfig.isPresent() && firstRhsString.isPresent()) {
            subscriptionContext.addIssue(firstRhsString.get(), DJANGO_MESSAGE);
        }
    }

    private void registerTypeCheckers(SubscriptionContext subscriptionContext) {
        this.argon2CheapestProfileTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("argon2.profiles.CHEAPEST");
        this.flaskConfigTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isInstanceOf("flask.config.Config");
        this.argon2IDTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("argon2.low_level.Type.ID");
        this.argon2VersionTypeChecker = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn("argon2.low_level.ARGON2_VERSION");
        this.typeCheckMap = new TypeCheckMap();
        this.callExpressionValidators.forEach((key, value) -> {
            TypeCheckBuilder typeCheckBuilder = subscriptionContext.typeChecker().typeCheckBuilder().isTypeWithFqn((String)key);
            this.typeCheckMap.put(typeCheckBuilder, (Collection<CommonValidationUtils.CallValidator>)value);
        });
    }

    private static void checkAssignment(SubscriptionContext subscriptionContext, TypeCheckBuilder flaskConfigTypeChecker) {
        AssignmentStatement stmt = (AssignmentStatement)subscriptionContext.syntaxNode();
        Optional<Expression> lhsSubscription = stmt.lhsExpressions().stream().findFirst().map(ExpressionList::expressions).flatMap(list -> list.stream().findFirst()).filter(expression -> FastHashingOrPlainTextCheck.subscriptionIsFlaskBcryptConfig(expression, flaskConfigTypeChecker));
        if (lhsSubscription.isEmpty()) {
            return;
        }
        if (CommonValidationUtils.isLessThan(stmt.assignedValue(), 12)) {
            subscriptionContext.addIssue(stmt.assignedValue(), BCRYPT_MESSAGE);
        }
    }

    private static boolean subscriptionIsFlaskBcryptConfig(Expression expression, TypeCheckBuilder flaskConfigTypeChecker) {
        if (!expression.is(Tree.Kind.SUBSCRIPTION)) {
            return false;
        }
        SubscriptionExpression subscription = (SubscriptionExpression)expression;
        if (flaskConfigTypeChecker.check(subscription.object().typeV2()) != TriBool.TRUE) {
            return false;
        }
        Optional<Expression> subscriptMatch = subscription.subscripts().expressions().stream().findFirst().filter(expr -> "BCRYPT_LOG_ROUNDS".equals(CommonValidationUtils.singleAssignedString(expr)));
        return subscriptMatch.isPresent();
    }

    private void checkName(SubscriptionContext subscriptionContext) {
        Name name = (Name)subscriptionContext.syntaxNode();
        if (this.argon2CheapestProfileTypeChecker.check(name.typeV2()) != TriBool.TRUE) {
            return;
        }
        AssignmentStatement ancestorAssign = (AssignmentStatement)TreeUtils.firstAncestorOfKind(name, Tree.Kind.ASSIGNMENT_STMT);
        if (ancestorAssign != null && FastHashingOrPlainTextCheck.isChildOf(ancestorAssign, name)) {
            return;
        }
        subscriptionContext.addIssue(name, "Use a secure Argon2 profile.");
    }

    private static boolean isChildOf(AssignmentStatement ancestorAssign, Name name) {
        return ancestorAssign.lhsExpressions().stream().flatMap(expressionList -> expressionList.children().stream()).anyMatch(tree -> tree == name);
    }

    private void checkCallExpr(SubscriptionContext subscriptionContext) {
        CallExpression callExpression = (CallExpression)subscriptionContext.syntaxNode();
        String qualifiedName = SymbolUtils.qualifiedNameOrEmpty(callExpression);
        Collection configsV2 = this.typeCheckMap.getOptionalForType(callExpression.callee().typeV2()).orElse(List.of());
        configsV2.forEach(config -> config.validate(subscriptionContext, callExpression));
        Collection configsV1 = CALL_EXPRESSION_VALIDATORS_V1.getOrDefault(qualifiedName, List.of());
        configsV1.forEach(config -> config.validate(subscriptionContext, callExpression));
        if (callExpression.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
            String fqn = TreeUtils.fullyQualifiedNameFromQualifiedExpression((QualifiedExpression)callExpression.callee()).orElse("");
            Collection configs = QUALIFIED_EXPR_VALIDATOR.getOrDefault(fqn, List.of());
            configs.forEach(config -> config.validate(subscriptionContext, callExpression));
        }
    }

    record Argon2PasswordHasherValidator(int timeCostPosition, int memoryCostPosition, int parallelismPosition) implements CommonValidationUtils.CallValidator
    {
        @Override
        public void validate(SubscriptionContext ctx, CallExpression callExpression) {
            boolean isParallelismNOk;
            RegularArgument timeCostArgument = TreeUtils.nthArgumentOrKeyword(this.timeCostPosition, "time_cost", callExpression.arguments());
            RegularArgument memoryCostArgument = TreeUtils.nthArgumentOrKeyword(this.memoryCostPosition, "memory_cost", callExpression.arguments());
            RegularArgument parallelismArgument = TreeUtils.nthArgumentOrKeyword(this.parallelismPosition, "parallelism", callExpression.arguments());
            boolean isTimeCostNOk = timeCostArgument != null && CommonValidationUtils.isLessThan(timeCostArgument.expression(), 5);
            boolean isMemoryCostNOk = memoryCostArgument != null && CommonValidationUtils.isLessThan(memoryCostArgument.expression(), 7168);
            boolean bl = isParallelismNOk = parallelismArgument != null && CommonValidationUtils.isEqualTo(parallelismArgument.expression(), 1);
            if (isMemoryCostNOk && isTimeCostNOk && isParallelismNOk) {
                ctx.addIssue(callExpression.callee(), FastHashingOrPlainTextCheck.ARGON2_MESSAGE);
            }
        }
    }

    record PBKDF2Validator(int algoPosition, String algoKeyword, int iterationsPosition, String iterationsKeyword) implements CommonValidationUtils.CallValidator
    {
        @Override
        public void validate(SubscriptionContext ctx, CallExpression callExpression) {
            Optional<RegularArgument> algoArgument = TreeUtils.nthArgumentOrKeywordOptional(this.algoPosition, this.algoKeyword, callExpression.arguments());
            String algoString = algoArgument.map(RegularArgument::expression).map(CommonValidationUtils::singleAssignedString).orElse("");
            if (!PBKDF2_ALGOS.contains(algoString)) {
                return;
            }
            TreeUtils.nthArgumentOrKeywordOptional(this.iterationsPosition, this.iterationsKeyword, callExpression.arguments()).filter(arg -> CommonValidationUtils.isLessThan(arg.expression(), 100000)).ifPresent(arg -> ctx.addIssue((Tree)arg, FastHashingOrPlainTextCheck.PBKDF2_MESSAGE));
        }
    }

    record MissingArgumentValidator(int position, String keywordName, String message) implements CommonValidationUtils.CallValidator
    {
        @Override
        public void validate(SubscriptionContext ctx, CallExpression callExpression) {
            TreeUtils.nthArgumentOrKeywordOptional(this.position, this.keywordName, callExpression.arguments()).ifPresentOrElse(regularArgument -> {}, () -> ctx.addIssue(callExpression.callee(), this.message));
        }
    }
}

