/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S4507")
public class DebugModeCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S4507";
    public static final String DJANGO_CONFIGURE_FQN = "django.conf.settings.configure";
    private static final String FLASK_RUN_FQN = "flask.app.Flask.run";
    private static final String FLASK_APP_CONFIG_FQN = "flask.app.Flask.config";
    public static final String FLASK_APP_DEBUG_FQN = "flask.app.Flask.debug";
    public static final String FLASK_GRAPHQL_VIEW_AS_VIEW_FQN = "flask_graphql.GraphQLView.as_view";
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final List<String> debugProperties = Arrays.asList("DEBUG", "DEBUG_PROPAGATE_EXCEPTIONS");
    private static final List<String> settingFiles = Arrays.asList("global_settings.py", "settings.py");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, DebugModeCheck::callExpressionConsumer);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, DebugModeCheck::assignmentStatementConsumer);
    }

    private static void callExpressionConsumer(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        List<Argument> arguments = callExpression.arguments();
        if (!(callExpression.callee() instanceof QualifiedExpression) || arguments.isEmpty()) {
            return;
        }
        String qualifiedName = SymbolUtils.qualifiedNameOrEmpty(callExpression);
        if (DJANGO_CONFIGURE_FQN.equals(qualifiedName)) {
            arguments.stream().filter(DebugModeCheck::isDebugArgument).forEach(arg -> ctx.addIssue((Tree)arg, MESSAGE));
        }
        if (FLASK_RUN_FQN.equals(qualifiedName)) {
            RegularArgument debugArgument = TreeUtils.nthArgumentOrKeyword(2, "debug", arguments);
            Optional.ofNullable(debugArgument).map(RegularArgument::expression).filter(DebugModeCheck::isTrue).ifPresent(name -> ctx.addIssue(debugArgument, MESSAGE));
        }
        if (DebugModeCheck.isFlaskGraphqlViewAsViewMethodCall(callExpression)) {
            RegularArgument argument = TreeUtils.nthArgumentOrKeyword(-1, "graphiql", arguments);
            Optional.ofNullable(argument).map(RegularArgument::expression).filter(DebugModeCheck::isTrue).ifPresent(name -> ctx.addIssue(argument, MESSAGE));
        }
    }

    private static boolean isFlaskGraphqlViewAsViewMethodCall(CallExpression callExpression) {
        String qualifiedName = SymbolUtils.qualifiedNameOrEmpty(callExpression);
        if (FLASK_GRAPHQL_VIEW_AS_VIEW_FQN.equals(qualifiedName)) {
            return true;
        }
        boolean isAsViewMethodCall = Optional.of(callExpression).map(CallExpression::calleeSymbol).map(Symbol::name).filter("as_view"::equals).isPresent();
        if (isAsViewMethodCall) {
            return Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::qualifier).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).filter(ClassSymbol.class::isInstance).map(ClassSymbol.class::cast).filter(s -> s.isOrExtends("flask_graphql.GraphQLView")).isPresent();
        }
        return false;
    }

    private static void assignmentStatementConsumer(SubscriptionContext ctx) {
        Optional.of(ctx.pythonFile().fileName()).filter(settingFiles::contains).ifPresentOrElse(fileName -> DebugModeCheck.assignmentStatementCheck(ctx, DebugModeCheck::hasDjangoOrFlaskDebugProperties), () -> DebugModeCheck.assignmentStatementCheck(ctx, DebugModeCheck::hasFlaskDebugProperties));
    }

    private static void assignmentStatementCheck(SubscriptionContext ctx, Predicate<ExpressionList> isDebugProperty) {
        AssignmentStatement assignmentStatementTree = (AssignmentStatement)ctx.syntaxNode();
        for (ExpressionList lhsExpression : assignmentStatementTree.lhsExpressions()) {
            if (!isDebugProperty.test(lhsExpression) || !DebugModeCheck.isTrue(assignmentStatementTree.assignedValue())) continue;
            ctx.addIssue(assignmentStatementTree, MESSAGE);
        }
    }

    private static boolean hasDjangoOrFlaskDebugProperties(ExpressionList expressionList) {
        return expressionList.expressions().stream().anyMatch(DebugModeCheck::isDebugIdentifier) || DebugModeCheck.hasFlaskDebugProperties(expressionList);
    }

    private static boolean hasFlaskDebugProperties(ExpressionList expressionList) {
        return expressionList.expressions().stream().anyMatch(DebugModeCheck::isModifyingFlaskDebugProperty);
    }

    private static boolean isModifyingFlaskDebugProperty(Expression expression) {
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return Optional.of((QualifiedExpression)expression).map(QualifiedExpression::symbol).map(Symbol::fullyQualifiedName).filter(FLASK_APP_DEBUG_FQN::equals).isPresent();
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            SubscriptionExpression subscriptionExpression = (SubscriptionExpression)expression;
            return DebugModeCheck.isFlaskAppConfiguration(subscriptionExpression) && DebugModeCheck.isMakingDebugParameterTrue(subscriptionExpression);
        }
        return false;
    }

    private static boolean isMakingDebugParameterTrue(SubscriptionExpression subscriptionExpression) {
        return Optional.of(subscriptionExpression.subscripts()).map(ExpressionList::expressions).filter(list -> list.size() == 1).map(list -> (Expression)list.get(0)).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).map(StringLiteral::trimmedQuotesValue).filter("DEBUG"::equals).isPresent();
    }

    private static boolean isFlaskAppConfiguration(SubscriptionExpression subscriptionExpression) {
        return Optional.of(subscriptionExpression).map(SubscriptionExpression::object).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::symbol).map(Symbol::fullyQualifiedName).filter(FLASK_APP_CONFIG_FQN::equals).isPresent();
    }

    private static boolean isDebugIdentifier(Expression expr) {
        return expr.is(Tree.Kind.NAME) && debugProperties.contains(((Name)expr).name());
    }

    private static boolean isTrue(Expression expr) {
        return Expressions.isTruthy(expr) || TreeUtils.toOptionalInstanceOf(Name.class, expr).map(Expressions::singleAssignedValue).filter(Expressions::isTruthy).isPresent();
    }

    private static boolean isDebugArgument(Argument argument) {
        Name keywordArgument;
        Name name = keywordArgument = argument.is(Tree.Kind.REGULAR_ARGUMENT) ? ((RegularArgument)argument).keywordArgument() : null;
        if (keywordArgument != null && debugProperties.contains(keywordArgument.name())) {
            return DebugModeCheck.isTrue(((RegularArgument)argument).expression());
        }
        return false;
    }
}

