/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.django;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6552")
public class DjangoReceiverDecoratorCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Move this '@receiver' decorator to the top of the other decorators.";
    private static final String QUICK_FIX_MESSAGE = "Move the '@receiver' decorator to the top";
    private static final String RECEIVER_DECORATOR_FQN = "django.dispatch.receiver";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            List<Decorator> decorators = functionDef.decorators();
            decorators.stream().filter(DjangoReceiverDecoratorCheck::isReceiverDecorator).findFirst().ifPresent(receiverDecorator -> {
                if (decorators.indexOf(receiverDecorator) != 0) {
                    PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)receiverDecorator, MESSAGE);
                    DjangoReceiverDecoratorCheck.addQuickFix(issue, functionDef, receiverDecorator);
                }
            });
        });
    }

    private static boolean isReceiverDecorator(Decorator decorator) {
        return Optional.of(decorator).map(Decorator::expression).flatMap(TreeUtils::fullyQualifiedNameFromExpression).filter(RECEIVER_DECORATOR_FQN::equals).isPresent();
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, FunctionDef functionDef, Decorator decorator) {
        PythonQuickFix.Builder builder = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE);
        List<Decorator> decorators = functionDef.decorators();
        int decoratorPosition = decorators.indexOf(decorator);
        Token removeTo = decorators.size() == decoratorPosition + 1 ? functionDef.defKeyword() : (Tree)decorators.get(decoratorPosition + 1);
        Optional.of(decorator).map(d -> TreeUtils.treeToString(d, true)).map(decoratorString -> TextEditUtils.insertBefore((Tree)decorators.get(0), decoratorString)).ifPresent(xva$0 -> builder.addTextEdit((PythonTextEdit)xva$0));
        PythonTextEdit removeEdit = TextEditUtils.removeUntil(decorator, removeTo);
        builder.addTextEdit(removeEdit);
        issue.addQuickFix(builder.build());
    }
}

