/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S4830")
public class VerifiedSslTlsCertificateCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Enable server certificate validation on this SSL/TLS connection.";
    private static final String VERIFY_NONE = "OpenSSL.SSL.VERIFY_NONE";
    private TypeCheckBuilder requestsSessionTypeCheck;
    private TypeCheckBuilder isOpenSslContextCheck;
    private TypeCheckBuilder isOpenSslContextSetVerifyCheck;
    private TypeCheckMap<Set<String>> requestsVerifyArguments;
    private static final String OPENSSL_CONTEXT_SET_VERIFY_FQN = "OpenSSL.SSL.Context.set_verify";
    private static final String OPENSSL_CONTEXT_FQN = "OpenSSL.SSL.Context";
    public static final Set<String> VERIFY_ARG_NAME = Set.of("verify");
    public static final String VERIFY_FIELD_NAME = "verify";
    public static final Set<String> VERIFY_SSL_ARG_NAMES = Set.of("verify_ssl", "ssl");
    public static final String REQUESTS_SESSIONS_FQN = "requests.sessions.Session";
    private static final Set<String> CALLS_WHERE_TO_ENFORCE_TRUE_ARGUMENT = Set.of("requests.api.request", "requests.api.get", "requests.api.head", "requests.api.post", "requests.api.put", "requests.api.delete", "requests.api.patch", "requests.api.options", "requests.sessions.Session.request", "requests.sessions.Session.get", "requests.sessions.Session.head", "requests.sessions.Session.post", "requests.sessions.Session.put", "requests.sessions.Session.delete", "requests.sessions.Session.patch", "httpx.request", "httpx.stream", "httpx.get", "httpx.options", "httpx.head", "httpx.post", "httpx.put", "httpx.patch", "httpx.delete", "httpx.Client", "httpx.AsyncClient");
    private static final Set<String> NO_ARG_FALSY_COLLECTION_CONSTRUCTORS = new HashSet<String>(Arrays.asList("set", "list", "dict"));
    private static final Map<String, Predicate<CallExpression>> VULNERABLE_CONTEXT_FACTORIES = Map.of("ssl._create_unverified_context", c -> true, "ssl._create_stdlib_context", c -> true, "ssl.create_default_context", c -> false, "ssl._create_default_https_context", c -> false, "ssl.SSLContext", VerifiedSslTlsCertificateCheck::isVulnerableSslContextInstantiation);
    private static final Set<String> VULNERABLE_SSL_PROTOCOLS = Set.of("ssl.PROTOCOL_SSLv23", "ssl.PROTOCOL_TLS", "ssl.PROTOCOL_SSLv3", "ssl.PROTOCOL_TLSv1", "ssl.PROTOCOL_TLSv1_1", "ssl.PROTOCOL_TLSv1_2");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, VerifiedSslTlsCertificateCheck::verifyAioHttpWithSession);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::openSslContextCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::requestsCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.REGULAR_ARGUMENT, VerifiedSslTlsCertificateCheck::standardSslCheckForRegularArgument);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, VerifiedSslTlsCertificateCheck::standardSslCheckForAssignmentStatement);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, this::requestsSessionAssignmentCheck);
    }

    private void initTypeChecks(SubscriptionContext ctx) {
        this.requestsSessionTypeCheck = ctx.typeChecker().typeCheckBuilder().isInstanceOf(REQUESTS_SESSIONS_FQN);
        this.isOpenSslContextCheck = ctx.typeChecker().typeCheckBuilder().isInstanceOf(OPENSSL_CONTEXT_FQN);
        this.isOpenSslContextSetVerifyCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName(OPENSSL_CONTEXT_SET_VERIFY_FQN);
        this.requestsVerifyArguments = new TypeCheckMap();
        CALLS_WHERE_TO_ENFORCE_TRUE_ARGUMENT.forEach(fqn -> {
            TypeCheckBuilder check = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn((String)fqn);
            this.requestsVerifyArguments.put(check, VERIFY_ARG_NAME);
        });
    }

    private static void verifyAioHttpWithSession(SubscriptionContext ctx) {
        WithStatement withStatement = (WithStatement)ctx.syntaxNode();
        withStatement.withItems().stream().filter(VerifiedSslTlsCertificateCheck::isAioHttpClientSessionCall).map(WithItem::expression).map(TreeUtils::getSymbolFromTree).filter(Optional::isPresent).map(Optional::get).forEach(symbol -> VerifiedSslTlsCertificateCheck.verifyAioHttpSessionSymbolUsages(ctx, symbol));
    }

    private static boolean isAioHttpClientSessionCall(WithItem item) {
        return Optional.of(item).map(WithItem::test).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).map(CallExpression::calleeSymbol).map(Symbol::fullyQualifiedName).filter("aiohttp.ClientSession"::equals).isPresent();
    }

    private static void verifyAioHttpSessionSymbolUsages(SubscriptionContext ctx, Symbol sessionSymbol) {
        sessionSymbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.OTHER).map(Usage::tree).map(t -> TreeUtils.firstAncestorOfKind(t, Tree.Kind.CALL_EXPR)).map(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).filter(Optional::isPresent).map(Optional::get).forEach(sessionCallExpr -> VerifiedSslTlsCertificateCheck.verifyVulnerableMethods(ctx, sessionCallExpr, VERIFY_SSL_ARG_NAMES));
    }

    private void openSslContextCheck(SubscriptionContext subscriptionContext) {
        AssignmentStatement assignmentStatement = (AssignmentStatement)subscriptionContext.syntaxNode();
        Expression assignedValue = assignmentStatement.lhsExpressions().get(0).expressions().get(0);
        Optional.of(assignedValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).filter(n -> this.isOpenSslContextCheck.check(n.typeV2()) == TriBool.TRUE).map(Name::symbolV2).ifPresent(symbol -> this.checkContextSymbol(subscriptionContext, (SymbolV2)symbol, assignedValue));
    }

    private void checkContextSymbol(SubscriptionContext subscriptionContext, SymbolV2 symbol, Expression assignedValue) {
        List<CallExpression> setVerifyCallExpressions = symbol.usages().stream().filter(Predicate.not(UsageV2::isBindingUsage)).map(UsageV2::tree).map(Tree::parent).flatMap(TreeUtils.toStreamInstanceOfMapper(QualifiedExpression.class)).filter(qe -> this.isOpenSslContextSetVerifyCheck.check(qe.typeV2()) == TriBool.TRUE).map(Tree::parent).flatMap(TreeUtils.toStreamInstanceOfMapper(CallExpression.class)).toList();
        if (setVerifyCallExpressions.isEmpty()) {
            subscriptionContext.addIssue(assignedValue, MESSAGE);
        } else {
            setVerifyCallExpressions.forEach(setVerifyCallExpression -> VerifiedSslTlsCertificateCheck.checkSetVerifyArguments(subscriptionContext, setVerifyCallExpression));
        }
    }

    private static void checkSetVerifyArguments(SubscriptionContext ctx, CallExpression setVerifyCallExpression) {
        TreeUtils.nthArgumentOrKeywordOptional(0, "mode", setVerifyCallExpression.arguments()).map(RegularArgument::expression).map(VerifiedSslTlsCertificateCheck::extractFlags).flatMap(VerifiedSslTlsCertificateCheck::checkFlagSettings).ifPresent(issueReport -> ctx.addIssue(issueReport.token, MESSAGE));
        TreeUtils.nthArgumentOrKeywordOptional(1, "callback", setVerifyCallExpression.arguments()).map(RegularArgument::expression).filter(callbackArgument -> VerifiedSslTlsCertificateCheck.findCallbackDefinition(callbackArgument).filter(VerifiedSslTlsCertificateCheck::isAlwaysTruthyCallback).isPresent()).ifPresent(callbackArgument -> ctx.addIssue((Tree)callbackArgument, MESSAGE));
    }

    private static Optional<FunctionDef> findCallbackDefinition(Expression callbackArgument) {
        return TreeUtils.toOptionalInstanceOf(Name.class, callbackArgument).map(Name::symbolV2).map(SymbolV2::usages).stream().flatMap(Collection::stream).filter(usageV2 -> usageV2.kind() == UsageV2.Kind.FUNC_DECLARATION).map(UsageV2::tree).map(Tree::parent).flatMap(TreeUtils.toStreamInstanceOfMapper(FunctionDef.class)).findFirst();
    }

    private static boolean isAlwaysTruthyCallback(FunctionDef callbackDefinition) {
        final ArrayList returns = new ArrayList();
        BaseTreeVisitor returnsCollector = new BaseTreeVisitor(){

            @Override
            public void visitReturnStatement(ReturnStatement returnStatement) {
                returns.add(returnStatement);
            }
        };
        callbackDefinition.accept(returnsCollector);
        return !returns.isEmpty() && returns.stream().allMatch(VerifiedSslTlsCertificateCheck::isTruthyReturnStatement);
    }

    private static boolean isTruthyReturnStatement(ReturnStatement returnStatement) {
        return returnStatement.expressions().size() == 1 && Expressions.isTruthy(returnStatement.expressions().get(0));
    }

    private static HashSet<QualifiedExpression> extractFlags(Tree flagsSubexpr) {
        if (flagsSubexpr.is(Tree.Kind.QUALIFIED_EXPR)) {
            return new HashSet<QualifiedExpression>(Collections.singletonList((QualifiedExpression)flagsSubexpr));
        }
        if (flagsSubexpr.is(Tree.Kind.BITWISE_OR)) {
            BinaryExpression orExpr = (BinaryExpression)flagsSubexpr;
            HashSet<QualifiedExpression> flags = VerifiedSslTlsCertificateCheck.extractFlags(orExpr.leftOperand());
            flags.addAll(VerifiedSslTlsCertificateCheck.extractFlags(orExpr.rightOperand()));
            return flags;
        }
        return new HashSet<QualifiedExpression>();
    }

    private static Optional<IssueReport> checkFlagSettings(Set<QualifiedExpression> flags) {
        for (QualifiedExpression qe : flags) {
            String fqn;
            Symbol symb = qe.symbol();
            if (symb == null || !VERIFY_NONE.equals(fqn = symb.fullyQualifiedName())) continue;
            return Optional.of(new IssueReport("Omitting the check of the peer certificate is dangerous.", qe.lastToken()));
        }
        return Optional.empty();
    }

    private void requestsSessionAssignmentCheck(SubscriptionContext ctx) {
        QualifiedExpression qualifiedExpression;
        Expression expression;
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        if (assignment.lhsExpressions().get(0).expressions().size() == 1 && (expression = assignment.lhsExpressions().get(0).expressions().get(0)) instanceof QualifiedExpression && this.requestsSessionTypeCheck.check((qualifiedExpression = (QualifiedExpression)expression).qualifier().typeV2()) == TriBool.TRUE && VERIFY_FIELD_NAME.equals(qualifiedExpression.name().name()) && Expressions.isFalsy(assignment.assignedValue())) {
            ctx.addIssue(assignment, MESSAGE);
        }
    }

    private void requestsCheck(SubscriptionContext subscriptionContext) {
        CallExpression callExpr = (CallExpression)subscriptionContext.syntaxNode();
        this.requestsVerifyArguments.getOptionalForType(callExpr.callee().typeV2()).ifPresent(args -> VerifiedSslTlsCertificateCheck.verifyVulnerableMethods(subscriptionContext, callExpr, args));
    }

    private static void verifyVulnerableMethods(SubscriptionContext ctx, CallExpression callExpr, Set<String> argumentNames) {
        Optional<List<Expression>> verifyRhs = VerifiedSslTlsCertificateCheck.searchVerifyAssignment(callExpr, argumentNames).or(() -> VerifiedSslTlsCertificateCheck.searchVerifyInKwargs(callExpr, argumentNames));
        verifyRhs.ifPresent(sensitiveSettingExpressions -> sensitiveSettingExpressions.stream().filter(rhs -> Expressions.isFalsy(rhs) || VerifiedSslTlsCertificateCheck.isFalsyCollection(rhs)).findFirst().ifPresent(rhs -> VerifiedSslTlsCertificateCheck.addIssue(ctx, sensitiveSettingExpressions, rhs)));
    }

    private static void addIssue(SubscriptionContext ctx, List<Expression> sensitiveSettingExpressions, Expression rhs) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(rhs, MESSAGE);
        sensitiveSettingExpressions.stream().filter(v -> v != rhs).forEach(v -> issue.secondary((Tree)v, "Dictionary is passed here as **kwargs."));
    }

    private static Optional<List<Expression>> searchVerifyAssignment(CallExpression callExpr, Set<String> argumentNames) {
        List<Expression> args = callExpr.arguments().stream().filter(RegularArgument.class::isInstance).map(RegularArgument.class::cast).filter(regArg -> Optional.of(regArg).map(RegularArgument::keywordArgument).map(Name::name).filter(argumentNames::contains).isPresent()).map(RegularArgument::expression).toList();
        return Optional.of(args).filter(Predicate.not(List::isEmpty));
    }

    private static Optional<List<Expression>> searchVerifyInKwargs(CallExpression callExpression, Set<String> argumentNames) {
        return callExpression.arguments().stream().filter(UnpackingExpression.class::isInstance).map(arg -> ((UnpackingExpression)arg).expression()).filter(Name.class::isInstance).findFirst().map(Name.class::cast).flatMap(name -> Optional.ofNullable(Expressions.singleAssignedValue(name)).filter(DictionaryLiteral.class::isInstance).map(DictionaryLiteral.class::cast).flatMap(dict -> VerifiedSslTlsCertificateCheck.searchDangerousVerifySettingInDictionary(dict, argumentNames)).map(settingInDict -> Arrays.asList(name, settingInDict)));
    }

    private static Optional<Expression> searchDangerousVerifySettingInDictionary(DictionaryLiteral dict, Set<String> argumentNames) {
        return dict.elements().stream().filter(KeyValuePair.class::isInstance).map(KeyValuePair.class::cast).filter(kvp -> Optional.of(kvp.key()).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).filter(argumentNames::contains).isPresent()).findFirst().map(KeyValuePair::value);
    }

    private static boolean isFalsyCollection(Expression expr) {
        CallExpression callExpr;
        Optional<String> fqnOpt;
        if (expr instanceof CallExpression && (fqnOpt = Optional.ofNullable((callExpr = (CallExpression)expr).calleeSymbol()).map(Symbol::fullyQualifiedName)).isPresent()) {
            String fqn = fqnOpt.get();
            return VerifiedSslTlsCertificateCheck.isFalsyNoArgCollectionConstruction(callExpr, fqn) || VerifiedSslTlsCertificateCheck.isFalsyRange(callExpr, fqn);
        }
        return false;
    }

    private static boolean isFalsyNoArgCollectionConstruction(CallExpression callExpr, String fqn) {
        return NO_ARG_FALSY_COLLECTION_CONSTRUCTORS.contains(fqn) && callExpr.arguments().isEmpty();
    }

    private static boolean isFalsyRange(CallExpression callExpr, String fqn) {
        RegularArgument regArg;
        Expression firstArgExpr;
        Argument firstArg;
        if ("range".equals(fqn) && callExpr.arguments().size() == 1 && (firstArg = callExpr.arguments().get(0)) instanceof RegularArgument && (firstArgExpr = (regArg = (RegularArgument)firstArg).expression()).is(Tree.Kind.NUMERIC_LITERAL)) {
            NumericLiteral num = (NumericLiteral)firstArgExpr;
            return num.valueAsLong() == 0L;
        }
        return false;
    }

    private static void standardSslCheckForAssignmentStatement(SubscriptionContext subscriptionContext) {
        AssignmentStatement asgnStmt = (AssignmentStatement)subscriptionContext.syntaxNode();
        TreeUtils.toOptionalInstanceOf(CallExpression.class, asgnStmt.assignedValue()).flatMap(VerifiedSslTlsCertificateCheck::isVulnerableMethodCall).ifPresent(vulnTok -> VerifiedSslTlsCertificateCheck.checkVulnerableMethodCallAssignment(subscriptionContext, asgnStmt, vulnTok));
    }

    private static void checkVulnerableMethodCallAssignment(SubscriptionContext subscriptionContext, AssignmentStatement asgnStmt, VulnerabilityAndProblematicToken vulnTok) {
        asgnStmt.lhsExpressions().stream().map(ExpressionList::expressions).flatMap(Collection::stream).findFirst().flatMap(TreeUtils::getSymbolFromTree).map(Symbol::usages).map(usages -> VerifiedSslTlsCertificateCheck.selectRelevantModifyingUsages(usages, vulnTok.token.line())).filter(usages -> usages.stream().noneMatch(VerifiedSslTlsCertificateCheck::isCheckHostnameAttributeSetToTrue)).ifPresent(usages -> {
            for (Usage u : usages) {
                VerifiedSslTlsCertificateCheck.searchForVerifyModeOverride(u).ifPresent(vulnTok::overrideBy);
            }
            if (vulnTok.isVulnerable) {
                subscriptionContext.addIssue(vulnTok.token, MESSAGE);
            }
        });
    }

    private static void standardSslCheckForRegularArgument(SubscriptionContext subscriptionContext) {
        TreeUtils.toOptionalInstanceOf(RegularArgument.class, subscriptionContext.syntaxNode()).map(RegularArgument::expression).flatMap(TreeUtils.toOptionalInstanceOfMapper(CallExpression.class)).flatMap(VerifiedSslTlsCertificateCheck::isVulnerableMethodCall).ifPresent(vulnTok -> subscriptionContext.addIssue(vulnTok.token, MESSAGE));
    }

    private static int findNextAssignmentLine(List<Usage> usages, int firstAssignmentLine) {
        int closestHigher = Integer.MAX_VALUE;
        for (Usage u : usages) {
            int line;
            if (!u.isBindingUsage() || (line = u.tree().firstToken().line()) <= firstAssignmentLine || line > closestHigher) continue;
            closestHigher = line;
        }
        return closestHigher;
    }

    private static List<Usage> selectRelevantModifyingUsages(List<Usage> usages, int firstAssignmentLine) {
        int nextAssignmentLine = VerifiedSslTlsCertificateCheck.findNextAssignmentLine(usages, firstAssignmentLine);
        return usages.stream().filter(Predicate.not(Usage::isBindingUsage)).filter(u -> {
            int line = u.tree().firstToken().line();
            return line > firstAssignmentLine && line < nextAssignmentLine;
        }).sorted(Comparator.comparing(u -> u.tree().firstToken().line())).toList();
    }

    private static boolean isVulnerableSslContextInstantiation(CallExpression sslConstructorCallExpression) {
        return TreeUtils.nthArgumentOrKeywordOptional(0, "protocol", sslConstructorCallExpression.arguments()).map(RegularArgument::expression).flatMap(TreeUtils::getSymbolFromTree).map(Symbol::fullyQualifiedName).filter(VULNERABLE_SSL_PROTOCOLS::contains).isPresent();
    }

    private static Optional<VulnerabilityAndProblematicToken> isVulnerableMethodCall(CallExpression callExpression) {
        return Optional.ofNullable(callExpression.calleeSymbol()).map(Symbol::fullyQualifiedName).map(VULNERABLE_CONTEXT_FACTORIES::get).map(predicate -> predicate.test(callExpression)).map(isVulnerable -> new VulnerabilityAndProblematicToken((boolean)isVulnerable, callExpression.callee().lastToken(), true));
    }

    private static Optional<VulnerabilityAndProblematicToken> searchForVerifyModeOverride(Usage u) {
        if (!u.isBindingUsage()) {
            return Optional.of(u).map(Usage::tree).map(Tree::parent).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).filter(qe -> "verify_mode".equals(qe.name().name())).map(Tree::parent).map(Tree::parent).filter(AssignmentStatement.class::isInstance).map(ae -> ((AssignmentStatement)ae).assignedValue()).filter(QualifiedExpression.class::isInstance).flatMap(qe -> Optional.ofNullable(((QualifiedExpression)qe).symbol()).map(symb -> new VulnerabilityAndProblematicToken("ssl.CERT_NONE".equals(symb.fullyQualifiedName()), qe.lastToken(), false)));
        }
        return Optional.empty();
    }

    private static boolean isCheckHostnameAttributeSetToTrue(Usage u) {
        return Optional.of(u).filter(Predicate.not(Usage::isBindingUsage)).map(Usage::tree).map(Tree::parent).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).filter(qe -> "check_hostname".equals(qe.name().name())).map(Tree::parent).map(Tree::parent).flatMap(TreeUtils.toOptionalInstanceOfMapper(AssignmentStatement.class)).map(AssignmentStatement::assignedValue).filter(Expressions::isTruthy).isPresent();
    }

    private record IssueReport(String message, Token token) {
    }

    private static class VulnerabilityAndProblematicToken {
        boolean isInvisibleDefaultPreset;
        boolean isVulnerable;
        Token token;

        VulnerabilityAndProblematicToken(boolean isVulnerable, Token token, boolean isInvisibleDefaultPreset) {
            this.isVulnerable = isVulnerable;
            this.token = token;
            this.isInvisibleDefaultPreset = isInvisibleDefaultPreset;
        }

        void overrideBy(VulnerabilityAndProblematicToken overridingAssignment) {
            this.isInvisibleDefaultPreset = false;
            this.isVulnerable = overridingAssignment.isVulnerable;
            this.token = overridingAssignment.token;
        }
    }
}

