/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1110")
public class UselessParenthesisCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1110";
    private static final String MESSAGE = "Remove those redundant parentheses.";
    public static final String QUICK_FIX_MESSAGE = "Remove the redundant parentheses";
    private boolean isPython314OrGreater = false;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan(ctx.sourcePythonVersions(), PythonVersionUtils.Version.V_314);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.PARENTHESIZED, ctx -> {
            ParenthesizedExpression parenthesized = (ParenthesizedExpression)ctx.syntaxNode();
            Expression expression = parenthesized.expression();
            if (expression.is(Tree.Kind.PARENTHESIZED, Tree.Kind.TUPLE, Tree.Kind.GENERATOR_EXPR) || this.isPython314OrGreater && UselessParenthesisCheck.isUselessExceptionParentheses(parenthesized)) {
                PythonCheck.PreciseIssue issue = ctx.addIssue(parenthesized.leftParenthesis(), MESSAGE).secondary(parenthesized.rightParenthesis(), null);
                PythonQuickFix quickFix = PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(TextEditUtils.remove(parenthesized.leftParenthesis()), TextEditUtils.remove(parenthesized.rightParenthesis())).build();
                issue.addQuickFix(quickFix);
            }
        });
    }

    private static boolean isUselessExceptionParentheses(ParenthesizedExpression parenthesized) {
        Tree exceptClause = TreeUtils.firstAncestorOfKind(parenthesized, Tree.Kind.EXCEPT_CLAUSE, Tree.Kind.EXCEPT_GROUP_CLAUSE);
        if (exceptClause == null) {
            return false;
        }
        Expression expression = parenthesized.expression();
        return !expression.is(Tree.Kind.TUPLE);
    }
}

