/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S6659")
public class UseStartsWithEndsWithCheck
extends PythonSubscriptionCheck {
    private static final String USE_STARTSWITH_MESSAGE = "Use `startswith` here.";
    private static final String USE_NOT_STARTSWITH_MESSAGE = "Use `not` and `startswith` here.";
    private static final String USE_ENDSWITH_MESSAGE = "Use `endswith` here.";
    private static final String USE_NOT_ENDSWITH_MESSAGE = "Use `not` and `endswith` here.";
    private static final Map<SliceType, Map<OperatorType, String>> MESSAGES = Map.of(SliceType.PREFIX, Map.of(OperatorType.EQUALS, "Use `startswith` here.", OperatorType.NOT_EQUALS, "Use `not` and `startswith` here."), SliceType.SUFFIX, Map.of(OperatorType.EQUALS, "Use `endswith` here.", OperatorType.NOT_EQUALS, "Use `not` and `endswith` here."));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> UseStartsWithEndsWithCheck.checkComparison(ctx, (BinaryExpression)ctx.syntaxNode()));
    }

    private static void checkComparison(SubscriptionContext ctx, BinaryExpression comparison) {
        Expression stringExpression;
        SliceExpression sliceExpression;
        OperatorType operatorType = OperatorType.fromString(comparison.operator().value());
        if (operatorType == OperatorType.OTHER) {
            return;
        }
        Expression lhs = comparison.leftOperand();
        Expression rhs = comparison.rightOperand();
        if (lhs.is(Tree.Kind.SLICE_EXPR)) {
            sliceExpression = (SliceExpression)lhs;
            stringExpression = rhs;
        } else if (rhs.is(Tree.Kind.SLICE_EXPR)) {
            sliceExpression = (SliceExpression)rhs;
            stringExpression = lhs;
        } else {
            return;
        }
        if (!stringExpression.type().mustBeOrExtend("str") && !sliceExpression.object().type().mustBeOrExtend("str")) {
            return;
        }
        List<Tree> slices = sliceExpression.sliceList().slices();
        if (slices.size() != 1) {
            return;
        }
        Tree sliceItem = slices.get(0);
        if (!sliceItem.is(Tree.Kind.SLICE_ITEM)) {
            return;
        }
        SliceType sliceType = SliceType.fromSliceItem((SliceItem)sliceItem);
        String message = UseStartsWithEndsWithCheck.selectMessage(sliceType, operatorType);
        if (message == null) {
            return;
        }
        ctx.addIssue(comparison, message);
    }

    @CheckForNull
    private static String selectMessage(SliceType sliceType, OperatorType operatorType) {
        Map<OperatorType, String> operatorMap = MESSAGES.get((Object)sliceType);
        if (operatorMap == null) {
            return null;
        }
        return operatorMap.get((Object)operatorType);
    }

    private static enum OperatorType {
        EQUALS,
        NOT_EQUALS,
        OTHER;


        private static OperatorType fromString(String operator) {
            if ("==".equals(operator)) {
                return EQUALS;
            }
            if ("!=".equals(operator)) {
                return NOT_EQUALS;
            }
            return OTHER;
        }
    }

    private static enum SliceType {
        PREFIX,
        SUFFIX,
        COMPLEX;


        private static SliceType fromSliceItem(SliceItem sliceItem) {
            Expression stride = sliceItem.stride();
            if (!(stride == null || stride.type().mustBeOrExtend("NoneType") || stride.is(Tree.Kind.NUMERIC_LITERAL) && stride.type().mustBeOrExtend("int") && ((NumericLiteral)stride).valueAsLong() == 1L)) {
                return COMPLEX;
            }
            Expression lowerBound = sliceItem.lowerBound();
            Expression upperBound = sliceItem.upperBound();
            if (!SliceType.isEmptyBound(lowerBound) && SliceType.isEmptyBound(upperBound)) {
                return SUFFIX;
            }
            if (!SliceType.isEmptyBound(upperBound) && SliceType.isEmptyBound(lowerBound)) {
                return PREFIX;
            }
            return COMPLEX;
        }

        private static boolean isEmptyBound(@CheckForNull Expression bound) {
            return bound == null || bound.type().mustBeOrExtend("NoneType");
        }
    }
}

