/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S3699")
public class UseOfEmptyReturnValueCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this use of the output from \"%s\"; \"%s\" doesn\u2019t return anything.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> UseOfEmptyReturnValueCheck.checkReturnValue(((AssignmentStatement)ctx.syntaxNode()).assignedValue(), ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.REGULAR_ARGUMENT, ctx -> UseOfEmptyReturnValueCheck.checkReturnValue(((RegularArgument)ctx.syntaxNode()).expression(), ctx));
    }

    private static void checkReturnValue(Expression expression, SubscriptionContext ctx) {
        boolean noneType;
        if (!expression.is(Tree.Kind.CALL_EXPR)) {
            return;
        }
        TypeCheckBuilder typeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("NoneType");
        boolean bl = noneType = typeCheckBuilder.check(expression.typeV2()) == TriBool.TRUE;
        if (noneType) {
            CallExpression callExpression = (CallExpression)expression;
            Optional.ofNullable(callExpression.calleeSymbol()).ifPresent(symbol -> ctx.addIssue(expression, String.format(MESSAGE, symbol.name(), symbol.name())));
        }
    }
}

