/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6542")
public class UseOfAnyAsTypeHintCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a more specific type than `Any` for this type hint.";
    private static final Set<String> OVERRIDE_FQNS = Set.of("typing.override", "typing.overload");
    private static final Set<String> OVERRIDE_NAMES = Set.of("override", "overload");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInReturnTypeAndParameters);
        context.registerSyntaxNodeConsumer(Tree.Kind.PARAMETER_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInReturnTypeAndParameters);
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, UseOfAnyAsTypeHintCheck::checkForAnyInTypeHint);
    }

    private static void checkForAnyInTypeHint(SubscriptionContext ctx) {
        Optional.of((TypeAnnotation)ctx.syntaxNode()).filter(UseOfAnyAsTypeHintCheck::isTypeAny).ifPresent(typeAnnotation -> ctx.addIssue(typeAnnotation.expression(), MESSAGE));
    }

    private static void checkForAnyInReturnTypeAndParameters(SubscriptionContext ctx) {
        TypeAnnotation typeAnnotation = (TypeAnnotation)ctx.syntaxNode();
        Optional.of(typeAnnotation).filter(UseOfAnyAsTypeHintCheck::isTypeAny).map(annotation -> (FunctionDef)TreeUtils.firstAncestorOfKind(annotation, Tree.Kind.FUNCDEF)).filter(Predicate.not(UseOfAnyAsTypeHintCheck::hasFunctionOverrideOrOverloadDecorator)).filter(Predicate.not(UseOfAnyAsTypeHintCheck::canFunctionBeAnOverride)).ifPresent(functionDef -> ctx.addIssue(typeAnnotation.expression(), MESSAGE));
    }

    private static boolean isTypeAny(@Nullable TypeAnnotation typeAnnotation) {
        return Optional.ofNullable(typeAnnotation).map(TypeAnnotation::expression).flatMap(TreeUtils::fullyQualifiedNameFromExpression).map("typing.Any"::equals).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasFunctionOverrideOrOverloadDecorator(FunctionDef currentFunctionDef) {
        if (currentFunctionDef.decorators().stream().map(Decorator::expression).anyMatch(expression -> expression.is(Tree.Kind.NAME) && OVERRIDE_NAMES.contains(((Name)expression).name()))) return true;
        if (!currentFunctionDef.decorators().stream().map(Decorator::expression).map(TreeUtils::fullyQualifiedNameFromExpression).flatMap(Optional::stream).anyMatch(OVERRIDE_FQNS::contains)) return false;
        return true;
    }

    private static boolean canFunctionBeAnOverride(FunctionDef currentMethodDef) {
        return Optional.ofNullable(TreeUtils.getFunctionSymbolFromDef(currentMethodDef)).map(SymbolUtils::canBeAnOverridingMethod).orElse(false);
    }
}

