/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S1128")
public class UnusedImportCheck
extends PythonVisitorCheck {
    private static final String MESSAGE = "Remove this unused import.";
    private static final Set<String> ALLOWED_MODULES = Set.of("__future__", "typing", "typing_extensions");
    private static final Set<String> ALLOWED_FQN_PREFIX = Set.of("sklearn.experimental.");
    private final Map<String, Name> unusedImports = new HashMap<String, Name>();

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.unusedImports.clear();
        if ("__init__.py".equals(this.getContext().pythonFile().fileName())) {
            return;
        }
        super.visitFileInput(fileInput);
        this.removeImportedNamesUsedInCommentsOrLiterals(fileInput);
        this.unusedImports.values().forEach(unusedImport -> this.addIssue((Tree)unusedImport, MESSAGE));
    }

    private void removeImportedNamesUsedInCommentsOrLiterals(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            for (Trivia trivia : ((Token)tree).trivia()) {
                this.unusedImports.values().removeIf(name -> trivia.value().contains(name.name()));
            }
        } else if (tree.is(Tree.Kind.STRING_LITERAL)) {
            this.unusedImports.remove(((StringLiteral)tree).trimmedQuotesValue());
        } else {
            for (Tree child : tree.children()) {
                this.removeImportedNamesUsedInCommentsOrLiterals(child);
            }
        }
    }

    @Override
    public void visitImportFrom(ImportFrom importFrom) {
        DottedName module = importFrom.module();
        if (module != null && module.names().size() == 1 && ALLOWED_MODULES.contains(module.names().get(0).name())) {
            return;
        }
        for (AliasedName aliasedName : importFrom.importedNames()) {
            Name alias = aliasedName.alias();
            Name importedName = alias != null ? alias : aliasedName.dottedName().names().get(0);
            Optional.ofNullable(importedName.symbol()).filter(symbol -> symbol.usages().stream().filter(u -> !u.isBindingUsage()).findFirst().isEmpty()).filter(symbol -> Optional.ofNullable(symbol.fullyQualifiedName()).map(fqn -> ALLOWED_FQN_PREFIX.stream().noneMatch(fqn::startsWith)).orElse(true)).ifPresent(symbol -> this.unusedImports.put(importedName.name(), importedName));
        }
        super.visitImportFrom(importFrom);
    }
}

