/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.StringLiteralImpl;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7942")
public class UnprocessedTemplateStringCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "This template string should be processed before use.";
    private static final List<String> BUILTIN_FUNCTION_NAMES = List.of("print", "str", "int", "float", "bool");
    private static final List<String> LOGGING_METHOD_TYPES = List.of("logging.debug", "logging.info", "logging.warning", "logging.error", "logging.critical");
    private boolean isPython314OrGreater = false;
    private TypeCheckMap<String> builtinFunctionTypeCheckers;
    private TypeCheckMap<String> loggingMethodTypeCheckers;
    private TypeCheckBuilder isStringFormat;
    private TypeCheckBuilder isStringJoin;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeState);
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> this.checkCondition((SubscriptionContext)ctx, ((IfStatement)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, ctx -> this.checkCondition((SubscriptionContext)ctx, ((WhileStatement)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_IF, ctx -> this.checkCondition((SubscriptionContext)ctx, ((ComprehensionIf)ctx.syntaxNode()).condition()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, this::checkConditionalExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, this::checkBinaryOperation);
        context.registerSyntaxNodeConsumer(Tree.Kind.IN, this::checkBinaryOperation);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
    }

    private void initializeState(SubscriptionContext ctx) {
        TypeCheckBuilder typeCheckBuilder;
        this.isPython314OrGreater = PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan(ctx.sourcePythonVersions(), PythonVersionUtils.Version.V_314);
        this.builtinFunctionTypeCheckers = new TypeCheckMap();
        for (String functionName : BUILTIN_FUNCTION_NAMES) {
            typeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName(functionName);
            this.builtinFunctionTypeCheckers.put(typeCheckBuilder, functionName);
        }
        this.loggingMethodTypeCheckers = new TypeCheckMap();
        for (String methodType : LOGGING_METHOD_TYPES) {
            typeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isTypeWithName(methodType);
            this.loggingMethodTypeCheckers.put(typeCheckBuilder, methodType);
        }
        this.isStringFormat = ctx.typeChecker().typeCheckBuilder().isTypeWithName("str.format");
        this.isStringJoin = ctx.typeChecker().typeCheckBuilder().isTypeWithName("str.join");
    }

    private void checkCondition(SubscriptionContext ctx, Expression condition) {
        if (!this.isPython314OrGreater) {
            return;
        }
        UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, condition);
    }

    private static void raiseIfIsUnprocessedTemplateString(SubscriptionContext ctx, Expression expression) {
        if (UnprocessedTemplateStringCheck.isUnprocessedTemplateString(expression)) {
            ctx.addIssue(expression, MESSAGE);
        }
    }

    private static boolean isUnprocessedTemplateString(Expression expression) {
        if (UnprocessedTemplateStringCheck.isTemplateString(expression)) {
            return true;
        }
        if (expression instanceof Name) {
            Name name = (Name)expression;
            return Expressions.singleAssignedNonNameValue(name).map(UnprocessedTemplateStringCheck::isTemplateString).orElse(false);
        }
        return false;
    }

    private static boolean isTemplateString(Expression expression) {
        if (expression instanceof StringLiteralImpl) {
            StringLiteralImpl stringLiteral = (StringLiteralImpl)expression;
            return stringLiteral.isTemplate();
        }
        return false;
    }

    private void checkBinaryOperation(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        BinaryExpression binaryExpr = (BinaryExpression)ctx.syntaxNode();
        UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, binaryExpr.leftOperand());
        UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, binaryExpr.rightOperand());
    }

    private void checkConditionalExpression(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        ConditionalExpression conditionalExpr = (ConditionalExpression)ctx.syntaxNode();
        UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, conditionalExpr.trueExpression());
        UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, conditionalExpr.falseExpression());
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        if (!this.isPython314OrGreater) {
            return;
        }
        CallExpression call = (CallExpression)ctx.syntaxNode();
        PythonType typeToCheck = call.callee().typeV2();
        if (this.builtinFunctionTypeCheckers.containsForType(typeToCheck) || this.loggingMethodTypeCheckers.containsForType(typeToCheck) || this.isStringFormat.check(typeToCheck).isTrue()) {
            call.arguments().forEach(arg -> {
                if (arg instanceof RegularArgument) {
                    RegularArgument regArg = (RegularArgument)arg;
                    UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, regArg.expression());
                }
            });
            return;
        }
        if (this.isStringJoin.check(typeToCheck).isTrue()) {
            UnprocessedTemplateStringCheck.checkJoinArguments(ctx, call);
        }
    }

    private static void checkJoinArguments(SubscriptionContext ctx, CallExpression call) {
        call.arguments().forEach(arg -> {
            if (arg instanceof RegularArgument) {
                RegularArgument regArg = (RegularArgument)arg;
                Expression argExpression = regArg.expression();
                if (argExpression instanceof ListLiteral) {
                    ListLiteral listLiteral = (ListLiteral)argExpression;
                    listLiteral.elements().expressions().forEach(element -> UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, element));
                } else if (argExpression instanceof Tuple) {
                    Tuple tuple = (Tuple)argExpression;
                    tuple.elements().forEach(element -> UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, element));
                } else {
                    UnprocessedTemplateStringCheck.raiseIfIsUnprocessedTemplateString(ctx, argExpression);
                }
            }
        });
    }
}

