/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7511")
public class UnnecessarySubscriptReversalCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isReversedTypeCheck;
    private TypeCheckBuilder isSortedTypeCheck;
    private TypeCheckBuilder isSetTypeCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isReversedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("reversed");
        this.isSortedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("sorted");
        this.isSetTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("set");
    }

    private void check(SubscriptionContext ctx) {
        TreeUtils.toOptionalInstanceOf(CallExpression.class, ctx.syntaxNode()).filter(this::isSensitiveCall).flatMap(callExpression -> UnnecessarySubscriptReversalCheck.getArgumentSubscriptReversal(callExpression).or(() -> UnnecessarySubscriptReversalCheck.getOuterSubscriptReversal(callExpression))).ifPresent(redundantSubscriptReversal -> ctx.addIssue((Tree)redundantSubscriptReversal, "Remove this redundant subscript reversal"));
    }

    private static Optional<Tree> getOuterSubscriptReversal(CallExpression callExpression) {
        return Optional.of(callExpression).map(Tree::parent).filter(UnnecessarySubscriptReversalCheck::isSubscriptReversal);
    }

    private static Optional<Tree> getArgumentSubscriptReversal(CallExpression callExpression) {
        return TreeUtils.nthArgumentOrKeywordOptional(0, "", callExpression.arguments()).map(RegularArgument::expression).filter(arg -> UnnecessarySubscriptReversalCheck.isSubscriptReversal(arg) || UnnecessarySubscriptReversalCheck.isAssignedToSubscriptReversal(arg)).map(Tree.class::cast);
    }

    private static boolean isAssignedToSubscriptReversal(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && UnnecessarySubscriptReversalCheck.getUsageCount(name = (Name)argumentExpression) == 2 && UnnecessarySubscriptReversalCheck.isSubscriptReversal(Expressions.singleAssignedValue(name));
    }

    private boolean isSensitiveCall(CallExpression callExpression) {
        return Stream.of(this.isReversedTypeCheck, this.isSortedTypeCheck, this.isSetTypeCheck).map(check -> check.check(callExpression.callee().typeV2())).anyMatch(TriBool.TRUE::equals);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSubscriptReversal(@Nullable Tree expression) {
        if (!(expression instanceof SliceExpression)) return false;
        SliceExpression sliceExpression = (SliceExpression)expression;
        if (sliceExpression.sliceList().slices().size() != 1) return false;
        Tree tree = sliceExpression.sliceList().slices().get(0);
        if (!(tree instanceof SliceItem)) return false;
        SliceItem sliceItem = (SliceItem)tree;
        if (sliceItem.lowerBound() != null) return false;
        if (sliceItem.upperBound() != null) return false;
        tree = sliceItem.stride();
        if (!(tree instanceof UnaryExpression)) return false;
        UnaryExpression unaryExpression = (UnaryExpression)tree;
        if (!unaryExpression.is(Tree.Kind.UNARY_MINUS)) return false;
        tree = unaryExpression.expression();
        if (!(tree instanceof NumericLiteral)) return false;
        NumericLiteral numericLiteral = (NumericLiteral)tree;
        if (numericLiteral.valueAsLong() != 1L) return false;
        return true;
    }

    private static int getUsageCount(Name name) {
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return 0;
        }
        return symbol.usages().size();
    }
}

