/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7516")
public class UnnecessarySortInsideSetCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove either the call to set or sorted.";
    private TypeCheckBuilder isSetTypeCheck;
    private TypeCheckBuilder isSortedTypeCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isSetTypeCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("set");
        this.isSortedTypeCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("sorted");
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression;
        Tree tree = ctx.syntaxNode();
        if (tree instanceof CallExpression && this.isSetCall(callExpression = (CallExpression)tree)) {
            TreeUtils.nthArgumentOrKeywordOptional(0, "", callExpression.arguments()).map(RegularArgument::expression).ifPresent(argumentExpression -> {
                if (this.isSortedCall((Expression)argumentExpression)) {
                    ctx.addIssue(callExpression.callee(), MESSAGE);
                } else {
                    this.isAssignedToSortedCall((Expression)argumentExpression).ifPresent(sortedCallExpr -> {
                        PythonCheck.PreciseIssue issue = ctx.addIssue(callExpression.callee(), MESSAGE);
                        issue.secondary(sortedCallExpr.callee(), "The list is sorted here.");
                    });
                }
            });
        }
    }

    private Optional<CallExpression> isAssignedToSortedCall(Expression argumentExpression) {
        Expression assignedValue;
        Name name;
        if (argumentExpression instanceof Name && UnnecessarySortInsideSetCheck.getUsageCount(name = (Name)argumentExpression) == 2 && this.isSortedCall(assignedValue = Expressions.singleAssignedValue(name))) {
            return Optional.of((CallExpression)assignedValue);
        }
        return Optional.empty();
    }

    private boolean isSetCall(CallExpression callExpression) {
        return this.isSetTypeCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private boolean isSortedCall(@Nullable Expression expression) {
        CallExpression callExpression;
        return expression instanceof CallExpression && this.isSortedTypeCheck.check((callExpression = (CallExpression)expression).callee().typeV2()) == TriBool.TRUE;
    }

    private static int getUsageCount(Name name) {
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return 0;
        }
        return symbol.usages().size();
    }
}

