/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7510")
public class UnnecessaryReversedCallCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isReversedTypeCheck;
    private TypeCheckBuilder isSortedTypeCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isReversedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("reversed");
        this.isSortedTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("sorted");
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression;
        Tree tree = ctx.syntaxNode();
        if (tree instanceof CallExpression && this.isReversedCall(callExpression = (CallExpression)tree)) {
            TreeUtils.nthArgumentOrKeywordOptional(0, "", callExpression.arguments()).map(RegularArgument::expression).ifPresent(argumentExpression -> {
                if (this.isSortedCall((Expression)argumentExpression) || this.isAssignedToSortedCall((Expression)argumentExpression)) {
                    ctx.addIssue(callExpression, "Remove this redundant reversed call, use reverse argument of the sorted function call instead");
                }
            });
        }
    }

    private boolean isAssignedToSortedCall(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && UnnecessaryReversedCallCheck.getUsageCount(name = (Name)argumentExpression) == 2 && this.isSortedCall(Expressions.singleAssignedValue(name));
    }

    private boolean isReversedCall(CallExpression callExpression) {
        return this.isReversedTypeCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private boolean isSortedCall(@Nullable Expression expression) {
        CallExpression callExpression;
        return expression instanceof CallExpression && this.isSortedTypeCheck.check((callExpression = (CallExpression)expression).callee().typeV2()) == TriBool.TRUE;
    }

    private static int getUsageCount(Name name) {
        SymbolV2 symbol = name.symbolV2();
        if (symbol == null) {
            return 0;
        }
        return symbol.usages().size();
    }
}

