/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7492")
public class UnnecessaryListComprehensionArgumentCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isAllTypeCheck;
    private TypeCheckBuilder isAnyTypeCheck;
    private TypeCheckBuilder isListTypeCheck;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isAllTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("all");
        this.isAnyTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("any");
        this.isListTypeCheck = ctx.typeChecker().typeCheckBuilder().isInstanceOf("list");
    }

    private void check(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (!this.isSensitiveCall(callExpression)) {
            return;
        }
        TreeUtils.nthArgumentOrKeywordOptional(0, "", callExpression.arguments()).map(RegularArgument::expression).ifPresent(argumentExpression -> {
            if (this.isListComprehensionExpression((Expression)argumentExpression) || this.isAssignedToListComprehensionExpression((Expression)argumentExpression)) {
                ctx.addIssue(callExpression, "Unpack this comprehension expression");
            }
        });
    }

    private boolean isListComprehensionExpression(@Nullable Expression expression) {
        ComprehensionExpression comprehensionExpression;
        return expression instanceof ComprehensionExpression && this.isListTypeCheck.check((comprehensionExpression = (ComprehensionExpression)expression).typeV2()) == TriBool.TRUE;
    }

    private boolean isAssignedToListComprehensionExpression(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && UnnecessaryListComprehensionArgumentCheck.getUsageCount(name = (Name)argumentExpression) == 2 && this.isListComprehensionExpression(Expressions.singleAssignedValue(name));
    }

    private boolean isSensitiveCall(CallExpression callExpression) {
        return Stream.of(this.isAllTypeCheck, this.isAnyTypeCheck).map(check -> check.check(callExpression.callee().typeV2())).anyMatch(TriBool.TRUE::equals);
    }

    private static int getUsageCount(Name name) {
        return Optional.of(name).map(Name::symbolV2).map(SymbolV2::usages).map(List::size).orElse(0);
    }
}

