/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.BuiltinSymbols;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5807")
public class UndefinedNameAllPropertyCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignmentStatement = (AssignmentStatement)ctx.syntaxNode();
            if (TreeUtils.firstAncestorOfKind(assignmentStatement, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF) != null) {
                return;
            }
            ExpressionList expressionList = assignmentStatement.lhsExpressions().get(0);
            if (expressionList.expressions().size() > 1) {
                return;
            }
            Expression lhs = expressionList.expressions().get(0);
            if (lhs.is(Tree.Kind.NAME) && "__all__".equals(((Name)lhs).name())) {
                UndefinedNameAllPropertyCheck.checkAllProperty(ctx, assignmentStatement);
            }
        });
    }

    private static void checkAllProperty(SubscriptionContext ctx, AssignmentStatement assignmentStatement) {
        Expression assignedValue = assignmentStatement.assignedValue();
        if (!assignedValue.is(Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE)) {
            return;
        }
        List<Tree> stringExpressions = UndefinedNameAllPropertyCheck.getStringExpressions(assignedValue);
        FileInput fileInput = (FileInput)TreeUtils.firstAncestorOfKind(assignedValue, Tree.Kind.FILE_INPUT);
        if (fileInput == null || UndefinedNameAllPropertyCheck.shouldExcludeFile(fileInput)) {
            return;
        }
        Map<String, Symbol> symbolsByName = fileInput.globalVariables().stream().collect(Collectors.toMap(Symbol::name, Function.identity()));
        for (Tree stringExpression : stringExpressions) {
            StringLiteral stringLiteral = UndefinedNameAllPropertyCheck.retrieveStringLiteral(stringExpression);
            if (!UndefinedNameAllPropertyCheck.isUnknownSymbol(ctx.pythonFile(), symbolsByName, stringLiteral)) continue;
            PythonCheck.PreciseIssue issue = ctx.addIssue(stringExpression, String.format("Change or remove this string; \"%s\" is not defined.", stringLiteral.trimmedQuotesValue()));
            if (stringExpression == stringLiteral) continue;
            issue.secondary(stringLiteral, "Assigned here.");
        }
    }

    private static boolean shouldExcludeFile(FileInput fileInput) {
        ModuleLevelVisitor moduleLevelVisitor = new ModuleLevelVisitor();
        fileInput.accept(moduleLevelVisitor);
        if (moduleLevelVisitor.hasGetAttrOrDirMethod) {
            return true;
        }
        UnknownNameSourcesVisitor unknownNameSourcesVisitor = new UnknownNameSourcesVisitor();
        fileInput.accept(unknownNameSourcesVisitor);
        return unknownNameSourcesVisitor.shouldNotReportIssue;
    }

    private static boolean isUnknownSymbol(PythonFile pythonFile, Map<String, Symbol> symbolsByName, StringLiteral stringLiteral) {
        String name = stringLiteral.trimmedQuotesValue();
        return stringLiteral.stringElements().stream().noneMatch(StringElement::isInterpolated) && !symbolsByName.containsKey(name) && !BuiltinSymbols.all().contains(name) && !UndefinedNameAllPropertyCheck.isInitFileExportingModule(pythonFile, name);
    }

    private static boolean isInitFileExportingModule(PythonFile pythonFile, String name) {
        return pythonFile.fileName().startsWith("__init__") && UndefinedNameAllPropertyCheck.existsFileWithName(pythonFile.uri(), name);
    }

    private static List<Tree> getStringExpressions(Expression expression) {
        if (expression.is(Tree.Kind.LIST_LITERAL)) {
            return ((ListLiteral)expression).elements().expressions().stream().filter(UndefinedNameAllPropertyCheck::isString).collect(Collectors.toList());
        }
        return ((Tuple)expression).elements().stream().filter(UndefinedNameAllPropertyCheck::isString).collect(Collectors.toList());
    }

    private static boolean existsFileWithName(@Nullable URI uri, String name) {
        return Optional.ofNullable(uri).map(u -> {
            String path = u.getPath();
            return new File(path = path.substring(0, path.lastIndexOf("/")), name + ".py").exists() || new File(path, name).exists();
        }).orElse(false);
    }

    private static boolean isString(Tree tree) {
        if (tree.is(Tree.Kind.STRING_LITERAL)) {
            return true;
        }
        if (tree.is(Tree.Kind.NAME)) {
            Expression expression = Expressions.singleAssignedValue((Name)tree);
            return expression != null && expression.is(Tree.Kind.STRING_LITERAL);
        }
        return false;
    }

    private static StringLiteral retrieveStringLiteral(Tree tree) {
        if (tree.is(Tree.Kind.STRING_LITERAL)) {
            return (StringLiteral)tree;
        }
        return (StringLiteral)Expressions.singleAssignedValue((Name)tree);
    }

    private static class ModuleLevelVisitor
    extends BaseTreeVisitor {
        private boolean hasGetAttrOrDirMethod = false;

        private ModuleLevelVisitor() {
        }

        @Override
        public void visitFunctionDef(FunctionDef functionDef) {
            this.hasGetAttrOrDirMethod |= "__getattr__".equals(functionDef.name().name()) || "__dir__".equals(functionDef.name().name());
        }

        @Override
        public void visitClassDef(ClassDef classDef) {
        }
    }

    private static class UnknownNameSourcesVisitor
    extends BaseTreeVisitor {
        private boolean shouldNotReportIssue = false;

        private UnknownNameSourcesVisitor() {
        }

        @Override
        public void visitImportFrom(ImportFrom importFrom) {
            this.shouldNotReportIssue |= importFrom.isWildcardImport();
            super.visitImportFrom(importFrom);
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            Symbol calleeSymbol = callExpression.calleeSymbol();
            this.shouldNotReportIssue |= UnknownNameSourcesVisitor.isSymbolWithFQN(calleeSymbol, "globals");
            super.visitCallExpression(callExpression);
        }

        @Override
        public void visitSubscriptionExpression(SubscriptionExpression subscriptionExpression) {
            Expression expression = subscriptionExpression.object();
            if (expression instanceof HasSymbol) {
                HasSymbol hasSymbol = (HasSymbol)((Object)expression);
                Symbol symbol = hasSymbol.symbol();
                this.shouldNotReportIssue |= UnknownNameSourcesVisitor.isSymbolWithFQN(symbol, "sys.modules");
            }
            super.visitSubscriptionExpression(subscriptionExpression);
        }

        private static boolean isSymbolWithFQN(@Nullable Symbol symbol, String fullyQualifiedName) {
            return symbol != null && fullyQualifiedName.equals(symbol.fullyQualifiedName());
        }
    }
}

