/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;

@Rule(key="S6794")
public class TypeAliasAnnotationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use a \"type\" statement instead of this \"TypeAlias\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.VARIABLE_TYPE_ANNOTATION, TypeAliasAnnotationCheck::checkTypeAliasVariableAnnotation);
    }

    public static void checkTypeAliasVariableAnnotation(SubscriptionContext ctx) {
        if (!TypeAliasAnnotationCheck.supportsTypeParameterSyntax(ctx)) {
            return;
        }
        TypeAnnotation typeAnnotation = (TypeAnnotation)ctx.syntaxNode();
        Optional.of(typeAnnotation.expression()).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).map(Symbol::fullyQualifiedName).filter("typing.TypeAlias"::equals).ifPresent(fqn -> ctx.addIssue(typeAnnotation.parent(), MESSAGE));
    }

    private static boolean supportsTypeParameterSyntax(SubscriptionContext ctx) {
        return PythonVersionUtils.areSourcePythonVersionsGreaterOrEqualThan(ctx.sourcePythonVersions(), PythonVersionUtils.Version.V_312);
    }
}

