/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S6979")
public class TorchAutogradVariableShouldNotBeUsedCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this call with a call to \"torch.tensor\".";
    private static final String TORCH_AUTOGRAD_VARIABLE = "torch.autograd.Variable";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol != null && TORCH_AUTOGRAD_VARIABLE.equals(calleeSymbol.fullyQualifiedName())) {
                ctx.addIssue(callExpression.callee(), MESSAGE);
            }
        });
    }
}

