/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.FunctionDefImpl;

@Rule(key="S107")
public class TooManyParametersCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S107";
    private static final String MESSAGE = "%s has %s parameters, which is greater than the %s authorized.";
    private static final int DEFAULT_MAX = 13;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="13")
    public int max = 13;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, this::checkFunctionDef);
        context.registerSyntaxNodeConsumer(Tree.Kind.LAMBDA, ctx -> {
            int nbParameters;
            LambdaExpression tree = (LambdaExpression)ctx.syntaxNode();
            ParameterList parameters = tree.parameters();
            if (parameters != null && (nbParameters = parameters.all().size()) > this.max) {
                String name = "Lambda";
                String message = String.format(MESSAGE, name, nbParameters, this.max);
                ctx.addIssue(parameters, message);
            }
        });
    }

    private void checkFunctionDef(SubscriptionContext ctx) {
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        ParameterList parameters = functionDef.parameters();
        FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
        if (parameters != null && functionSymbol != null) {
            long nbParameters = functionSymbol.parameters().size();
            boolean isMethod = functionDef.isMethodDefinition();
            if (isMethod && functionSymbol.decorators().stream().noneMatch(d -> d.contains("staticmethod"))) {
                --nbParameters;
            }
            if (nbParameters > (long)this.max) {
                if (isMethod && this.isAlreadyReportedInParent(functionSymbol)) {
                    return;
                }
                String typeName = isMethod ? "Method" : "Function";
                String name = String.format("%s \"%s\"", typeName, functionDef.name().name());
                String message = String.format(MESSAGE, name, nbParameters, this.max);
                ctx.addIssue(parameters, message);
            }
        }
    }

    private boolean isAlreadyReportedInParent(FunctionSymbol functionSymbol) {
        return SymbolUtils.getOverriddenMethods(functionSymbol).stream().findFirst().map(f -> {
            int nbParameters = f.parameters().size();
            if (f.decorators().stream().anyMatch(d -> d.contains("staticmethod"))) {
                --nbParameters;
            }
            return nbParameters > this.max;
        }).orElse(false);
    }
}

