/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6908")
public class TfFunctionRecursivityCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure to avoid recursive calls in this function.";
    private static final String SECONDARY_MESSAGE = "Recursive call is here.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, TfFunctionRecursivityCheck::checkFunctionDef);
    }

    private static void checkFunctionDef(SubscriptionContext context) {
        FunctionDef functionDef = (FunctionDef)context.syntaxNode();
        if (!TreeUtils.isFunctionWithGivenDecoratorFQN(functionDef, "tensorflow.function")) {
            return;
        }
        FunctionSymbol functionSymbol = TreeUtils.getFunctionSymbolFromDef(functionDef);
        if (functionSymbol == null) {
            return;
        }
        CallCollector collector = new CallCollector(functionSymbol);
        functionDef.accept(collector);
        if (collector.expressionList.isEmpty()) {
            return;
        }
        PythonCheck.PreciseIssue issue = context.addIssue(functionDef.name(), MESSAGE);
        collector.expressionList.forEach(call -> issue.secondary((Tree)call, SECONDARY_MESSAGE));
    }

    private static class CallCollector
    extends BaseTreeVisitor {
        private final Symbol originalSymbol;
        List<Expression> expressionList = new ArrayList<Expression>();

        private CallCollector(Symbol originalSymbol) {
            this.originalSymbol = originalSymbol;
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            TreeUtils.getSymbolFromTree(callExpression.callee()).filter(symbol -> symbol.equals(this.originalSymbol)).ifPresent(symbol -> this.expressionList.add(callExpression.callee()));
            super.visitCallExpression(callExpression);
        }
    }
}

