/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7513")
public class TaskGroupNurseryUsedOnlyOnceCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace the %s with a direct function call when it only ever spawns one task.";
    private static final String SECONDARY_MESSAGE = "Only task created here";
    private TypeCheckBuilder asyncioTaskGroupTypeChecker;
    private TypeCheckBuilder trioNurseryTypeChecker;
    private TypeCheckBuilder anyioTaskGroupTypeChecker;
    private static final Set<String> START_METHOD_NAMES = Set.of("start_soon", "start", "create_task");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initTypeCheckers);
        context.registerSyntaxNodeConsumer(Tree.Kind.WITH_STMT, this::checkWithStatement);
    }

    private void initTypeCheckers(SubscriptionContext ctx) {
        this.asyncioTaskGroupTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("asyncio.TaskGroup");
        this.trioNurseryTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("trio.open_nursery");
        this.anyioTaskGroupTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("anyio.create_task_group");
    }

    private void checkWithStatement(SubscriptionContext ctx) {
        WithStatement withStmt = (WithStatement)ctx.syntaxNode();
        if (!withStmt.isAsync()) {
            return;
        }
        for (WithItem item : withStmt.withItems()) {
            this.handleWithItem(ctx, item, withStmt);
        }
    }

    private void handleWithItem(SubscriptionContext ctx, WithItem item, WithStatement withStmt) {
        CallExpression callExpr;
        Expression test = item.test();
        if (!(test instanceof CallExpression) || this.isTaskGroupOrNurseryCall(callExpr = (CallExpression)test).isEmpty()) {
            return;
        }
        Expression aliasExpr = item.expression();
        if (!(aliasExpr instanceof Name)) {
            return;
        }
        Name aliasNameTree = (Name)aliasExpr;
        SymbolV2 aliasSym = aliasNameTree.symbolV2();
        if (aliasSym == null) {
            return;
        }
        TaskGroupNurseryUsedOnlyOnceCheck.shouldRaise(aliasSym, withStmt).ifPresent(spawnCall -> ctx.addIssue(aliasExpr, String.format(MESSAGE, this.isTaskGroupOrNurseryCall(callExpr).get())).secondary((Tree)spawnCall, SECONDARY_MESSAGE));
    }

    private Optional<String> isTaskGroupOrNurseryCall(CallExpression callExpr) {
        PythonType calleeType = callExpr.callee().typeV2();
        if (this.asyncioTaskGroupTypeChecker.check(calleeType) == TriBool.TRUE || this.anyioTaskGroupTypeChecker.check(calleeType) == TriBool.TRUE) {
            return Optional.of("TaskGroup");
        }
        if (this.trioNurseryTypeChecker.check(calleeType) == TriBool.TRUE) {
            return Optional.of("Nursery");
        }
        return Optional.empty();
    }

    private static boolean isSpawnCall(QualifiedExpression qualifiedExpression) {
        return START_METHOD_NAMES.contains(qualifiedExpression.name().name());
    }

    private static Optional<Tree> shouldRaise(SymbolV2 aliasSym, WithStatement withStmt) {
        List<UsageV2> usagesInWithScope = aliasSym.usages().stream().filter(u -> !u.isBindingUsage()).filter(u -> TreeUtils.firstAncestor(u.tree(), t -> t == withStmt) != null).toList();
        QualifiedExpression spawnCall = null;
        for (UsageV2 usage : usagesInWithScope) {
            QualifiedExpression qe;
            Tree parent = usage.tree().parent();
            if (parent instanceof QualifiedExpression && TaskGroupNurseryUsedOnlyOnceCheck.isSpawnCall(qe = (QualifiedExpression)parent)) {
                if (spawnCall != null || TaskGroupNurseryUsedOnlyOnceCheck.isInsideLoop(qe)) {
                    return Optional.empty();
                }
                spawnCall = qe;
                continue;
            }
            return Optional.empty();
        }
        return Optional.ofNullable(spawnCall);
    }

    private static boolean isInsideLoop(Tree tree) {
        return TreeUtils.firstAncestorOfKind(tree, Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT) != null;
    }
}

