/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1192")
public class StringLiteralDuplicationCheck
extends PythonVisitorCheck {
    private static final Integer MINIMUM_LITERAL_LENGTH = 5;
    private static final int DEFAULT_THRESHOLD = 3;
    private static final Pattern BASIC_EXCLUSION_PATTERN = Pattern.compile("[_\\-a-zA-Z0-9]+");
    private static final Pattern FORMATTING_PATTERN = Pattern.compile("[0-9{} .\\-_%:dfrsymhYMHS<>]+");
    private static final Pattern COLOR_PATTERN = Pattern.compile("#[0-9a-fA-F]{6}");
    private static final String DEFAULT_CUSTOM_EXCLUSION_PATTERN = "";
    private Pattern customPattern = null;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    @RuleProperty(key="exclusionRegex", description="RegEx matching literals to exclude from triggering an issue", defaultValue="")
    public String customExclusionRegex = "";
    private Map<String, List<StringLiteral>> literalsByValue = new HashMap<String, List<StringLiteral>>();
    private boolean isCustomPatternInitialized = false;

    private Optional<Pattern> customExclusionPattern() {
        if (!this.isCustomPatternInitialized) {
            if (this.customExclusionRegex != null && !this.customExclusionRegex.isEmpty()) {
                try {
                    this.customPattern = Pattern.compile(this.customExclusionRegex, 32);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Unable to compile regular expression: " + this.customExclusionRegex, e);
                }
            }
            this.isCustomPatternInitialized = true;
        }
        return Optional.ofNullable(this.customPattern);
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.literalsByValue.clear();
        if (this.getContext().pythonFile().fileName().startsWith("test")) {
            return;
        }
        super.visitFileInput(fileInput);
        for (Map.Entry<String, List<StringLiteral>> entry : this.literalsByValue.entrySet()) {
            List<StringLiteral> occurrences = entry.getValue();
            int nbOfOccurrences = occurrences.size();
            if (nbOfOccurrences < this.threshold) continue;
            StringLiteral first = occurrences.get(0);
            String message = String.format("Define a constant instead of duplicating this literal %s %s times.", first.firstToken().value(), nbOfOccurrences);
            PythonCheck.PreciseIssue issue = this.addIssue(first, message).withCost(nbOfOccurrences - 1);
            occurrences.stream().skip(1L).forEach(stringLiteral -> issue.secondary((Tree)stringLiteral, "Duplication"));
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement expressionStatement) {
        if (!expressionStatement.expressions().get(0).is(Tree.Kind.STRING_LITERAL)) {
            super.visitExpressionStatement(expressionStatement);
        }
    }

    @Override
    public void visitStringLiteral(StringLiteral literal) {
        boolean isExcluded;
        String value = Expressions.unescape(literal);
        boolean hasInterpolation = literal.stringElements().stream().anyMatch(StringElement::isInterpolated);
        boolean bl = isExcluded = hasInterpolation || value.length() < MINIMUM_LITERAL_LENGTH || BASIC_EXCLUSION_PATTERN.matcher(value).matches() || FORMATTING_PATTERN.matcher(value).matches() || COLOR_PATTERN.matcher(value).matches() || this.matchesCustomExclusionPattern(value);
        if (!isExcluded) {
            String valueWithQuotes = TreeUtils.tokens(literal).stream().map(Token::value).collect(Collectors.joining());
            this.literalsByValue.computeIfAbsent(valueWithQuotes, key -> new ArrayList()).add(literal);
        }
    }

    private boolean matchesCustomExclusionPattern(String value) {
        return this.customExclusionPattern().map(p -> p.matcher(value).matches()).orElse(false);
    }

    @Override
    public void visitDecorator(Decorator decorator) {
    }

    @Override
    public void visitTypeAnnotation(TypeAnnotation typeAnnotation) {
    }
}

