/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.hotspots.CommonValidationUtils;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7491")
public class SleepZeroInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use %s instead of %s.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final String QUICK_FIX_MESSAGE = "Replace with %s";
    private TypeCheckMap<MessageHolder> asyncSleepFunctions;
    private final Map<String, String> asyncLibraryAliases = new HashMap<String, String>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeAnalysis);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, this::handleImportName);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpr);
    }

    private void initializeAnalysis(SubscriptionContext context) {
        this.asyncSleepFunctions = TypeCheckMap.ofEntries(Map.entry(context.typeChecker().typeCheckBuilder().isTypeWithFqn("trio.sleep"), new MessageHolder("trio.sleep", "%s.lowlevel.checkpoint()", "seconds", "trio")), Map.entry(context.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName("anyio.sleep"), new MessageHolder("anyio.sleep", "%s.lowlevel.checkpoint()", "delay", "anyio")));
        this.asyncLibraryAliases.clear();
    }

    private void handleImportName(SubscriptionContext context) {
        ImportName importName = (ImportName)context.syntaxNode();
        importName.modules().forEach(this::trackModuleImport);
    }

    private void trackModuleImport(AliasedName aliasedName) {
        List<Name> names = aliasedName.dottedName().names();
        if (names.size() > 1) {
            return;
        }
        String moduleName = names.get(0).name();
        if ("trio".equals(moduleName) || "anyio".equals(moduleName)) {
            Name alias = aliasedName.alias();
            String moduleAlias = alias != null ? alias.name() : moduleName;
            this.asyncLibraryAliases.put(moduleName, moduleAlias);
        }
    }

    private void checkCallExpr(SubscriptionContext context) {
        CallExpression callExpr = (CallExpression)context.syntaxNode();
        Token asyncKeyword = TreeUtils.asyncTokenOfEnclosingFunction(callExpr).orElse(null);
        if (asyncKeyword == null) {
            return;
        }
        Expression callee = callExpr.callee();
        this.asyncSleepFunctions.getOptionalForType(callee.typeV2()).ifPresent(messageHolder -> SleepZeroInAsyncCheck.handleCallExpr(context, messageHolder, callExpr, asyncKeyword, this.asyncLibraryAliases));
    }

    private static void handleCallExpr(SubscriptionContext context, MessageHolder messageHolder, CallExpression callExpr, Tree asyncKeyword, Map<String, String> asyncLibraryAliases) {
        if (!SleepZeroInAsyncCheck.isZero(callExpr, messageHolder.keywordArgumentName())) {
            return;
        }
        String moduleAlias = asyncLibraryAliases.getOrDefault(messageHolder.libraryName(), messageHolder.libraryName());
        String formattedReplacement = messageHolder.replacement().formatted(moduleAlias);
        String message = String.format(MESSAGE, formattedReplacement, messageHolder.fqn());
        PythonCheck.PreciseIssue issue = context.addIssue(callExpr, message);
        issue.secondary(asyncKeyword, SECONDARY_MESSAGE);
        SleepZeroInAsyncCheck.createQuickFix(messageHolder, callExpr, formattedReplacement, asyncLibraryAliases).ifPresent(issue::addQuickFix);
    }

    private static Optional<PythonQuickFix> createQuickFix(MessageHolder messageHolder, CallExpression callExpr, String formattedReplacement, Map<String, String> asyncLibraryAliases) {
        if (!asyncLibraryAliases.containsKey(messageHolder.libraryName())) {
            return Optional.empty();
        }
        String quickFixMessage = String.format(QUICK_FIX_MESSAGE, formattedReplacement);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix(quickFixMessage).addTextEdit(TextEditUtils.replace(callExpr, formattedReplacement)).build();
        return Optional.of(quickFix);
    }

    private static boolean isZero(CallExpression callExpr, String keywordArgumentName) {
        RegularArgument argument = TreeUtils.nthArgumentOrKeyword(0, keywordArgumentName, callExpr.arguments());
        if (argument == null) {
            return false;
        }
        return CommonValidationUtils.isEqualTo(argument.expression(), 0);
    }

    record MessageHolder(String fqn, String replacement, String keywordArgumentName, String libraryName) {
    }
}

