/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.CheckUtils;

@Rule(key="S1862")
public class SameConditionCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1862";
    private static final String MESSAGE = "This branch duplicates the one on line %s.";
    private List<IfStatement> ignoreList;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.ignoreList = new ArrayList<IfStatement>();
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            IfStatement ifStatement = (IfStatement)ctx.syntaxNode();
            if (this.ignoreList.contains(ifStatement)) {
                return;
            }
            List<Expression> conditions = this.getConditionsToCompare(ifStatement);
            SameConditionCheck.findSameConditions(conditions, ctx);
        });
    }

    private List<Expression> getConditionsToCompare(IfStatement ifStatement) {
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        conditions.add(ifStatement.condition());
        conditions.addAll(ifStatement.elifBranches().stream().map(IfStatement::condition).toList());
        ElseClause elseClause = ifStatement.elseBranch();
        if (elseClause != null) {
            this.lookForElseIfs(conditions, elseClause);
        }
        return conditions;
    }

    private void lookForElseIfs(List<Expression> conditions, ElseClause elseBranch) {
        IfStatement singleIfChild = SameConditionCheck.singleIfChild(elseBranch.body());
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            conditions.addAll(this.getConditionsToCompare(singleIfChild));
        }
    }

    private static void findSameConditions(List<Expression> conditions, SubscriptionContext ctx) {
        for (int i = 1; i < conditions.size(); ++i) {
            SameConditionCheck.compareConditions(conditions, i, ctx);
        }
    }

    private static void compareConditions(List<Expression> conditions, int index, SubscriptionContext ctx) {
        for (int j = 0; j < index; ++j) {
            if (!CheckUtils.areEquivalent(conditions.get(j), conditions.get(index))) continue;
            String message = String.format(MESSAGE, conditions.get(j).firstToken().line());
            ctx.addIssue(conditions.get(index), message).secondary(conditions.get(j), "Original");
            return;
        }
    }

    private static IfStatement singleIfChild(StatementList statementList) {
        List<Statement> statements = statementList.statements();
        if (statements.size() == 1 && statements.get(0).is(Tree.Kind.IF_STMT)) {
            return (IfStatement)statements.get(0);
        }
        return null;
    }
}

