/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.DeclaredType;

public class ReturnCheckUtils {
    private ReturnCheckUtils() {
    }

    static void addIssueOnReturnedExpressions(SubscriptionContext ctx, ReturnStatement returnStatement, String message) {
        List<Expression> returnedExpressions = returnStatement.expressions();
        if (returnedExpressions.isEmpty()) {
            ctx.addIssue(returnStatement.returnKeyword(), message);
        } else {
            Token firstExpressionToken = returnedExpressions.get(0).firstToken();
            Token lastExpressionToken = returnedExpressions.get(returnedExpressions.size() - 1).lastToken();
            ctx.addIssue(firstExpressionToken, lastExpressionToken, message);
        }
    }

    static void addIssueIfAsync(SubscriptionContext ctx, FunctionDef funDef, String message) {
        Token asyncKeyword = funDef.asyncKeyword();
        if (asyncKeyword != null) {
            ctx.addIssue(asyncKeyword, message);
        }
    }

    static class ReturnStmtCollector
    extends BaseTreeVisitor {
        private final List<ReturnStatement> returnStmts = new ArrayList<ReturnStatement>();
        private final List<Token> yieldKeywords = new ArrayList<Token>();
        private boolean raisesExceptions = false;
        private static final List<String> BOTTOM_TYPES = List.of("typing.NoReturn", "typing.Never");

        private ReturnStmtCollector() {
        }

        static ReturnStmtCollector collect(FunctionDef funDef) {
            ReturnStmtCollector returnStmtCollector = new ReturnStmtCollector();
            funDef.body().accept(returnStmtCollector);
            return returnStmtCollector;
        }

        public List<ReturnStatement> getReturnStmts() {
            return this.returnStmts;
        }

        public List<Token> getYieldKeywords() {
            return this.yieldKeywords;
        }

        public boolean containsYield() {
            return !this.yieldKeywords.isEmpty();
        }

        public boolean raisesExceptions() {
            return this.raisesExceptions;
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStmt) {
            this.returnStmts.add(returnStmt);
        }

        @Override
        public void visitFunctionDef(FunctionDef funDef) {
        }

        @Override
        public void visitYieldStatement(YieldStatement yieldStmt) {
            this.yieldKeywords.add(yieldStmt.yieldExpression().yieldKeyword());
        }

        @Override
        public void visitYieldExpression(YieldExpression yieldExpr) {
            this.yieldKeywords.add(yieldExpr.yieldKeyword());
        }

        @Override
        public void visitLambda(LambdaExpression lambdaExpr) {
        }

        @Override
        public void visitRaiseStatement(RaiseStatement raiseStmt) {
            this.raisesExceptions = true;
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            InferredType returnType = callExpression.type();
            if (!(returnType instanceof DeclaredType)) {
                return;
            }
            String fullyQualifiedTypeName = ((DeclaredType)returnType).getTypeClass().fullyQualifiedName();
            this.raisesExceptions |= BOTTOM_TYPES.stream().anyMatch(bottomType -> bottomType.equals(fullyQualifiedTypeName));
        }
    }
}

