/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S6741")
public class PandasDataFrameToNumpyCheck
extends PythonSubscriptionCheck {
    private static final String DATAFRAME_VALUES_FQN = "pandas.core.frame.DataFrame.values";
    private static final String MESSAGE = "Do not use \"DataFrame.values\".";
    private static final String QUICK_FIX_MESSAGE = "Replace with \"DataFrame.to_numpy()\"";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.QUALIFIED_EXPR, this::checkForDataFrameValues);
    }

    private void checkForDataFrameValues(SubscriptionContext ctx) {
        QualifiedExpression expr = (QualifiedExpression)ctx.syntaxNode();
        if (Optional.of(expr).filter(ex -> "values".equals(ex.name().name())).isEmpty()) {
            return;
        }
        expr.qualifier().type().resolveMember("values").map(Symbol::fullyQualifiedName).filter(DATAFRAME_VALUES_FQN::equals).ifPresent(str -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue(expr.name(), MESSAGE);
            issue.addQuickFix(PythonQuickFix.newQuickFix(QUICK_FIX_MESSAGE).addTextEdit(TextEditUtils.replace(expr.name(), "to_numpy()")).build());
        });
    }
}

