/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;

@Rule(key="S6729")
public class NumpyWhereOneConditionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use \"np.nonzero\" when only the condition parameter is provided to \"np.where\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, NumpyWhereOneConditionCheck::checkNumpyWhereCall);
    }

    private static void checkNumpyWhereCall(SubscriptionContext ctx) {
        CallExpression ce = (CallExpression)ctx.syntaxNode();
        Symbol symbol = ce.calleeSymbol();
        Optional.ofNullable(symbol).map(Symbol::fullyQualifiedName).filter("numpy.where"::equals).filter(fqn -> NumpyWhereOneConditionCheck.hasOneParameter(ce)).ifPresent(fqn -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue(ce, MESSAGE);
            NumpyWhereOneConditionCheck.addQuickFix(ce, issue);
        });
    }

    private static void addQuickFix(CallExpression ce, PythonCheck.PreciseIssue issue) {
        Optional.of(ce.callee()).filter(exp -> exp.is(Tree.Kind.QUALIFIED_EXPR)).map(QualifiedExpression.class::cast).map(QualifiedExpression::name).map(NumpyWhereOneConditionCheck::getQuickFix).ifPresent(issue::addQuickFix);
    }

    private static PythonQuickFix getQuickFix(Name qe) {
        return PythonQuickFix.newQuickFix("Replace numpy.where with numpy.nonzero").addTextEdit(TextEditUtils.replace(qe, "nonzero")).build();
    }

    private static boolean hasOneParameter(CallExpression ce) {
        List<Argument> argList = ce.arguments();
        if (argList.size() != 1 || argList.get(0).is(Tree.Kind.UNPACKING_EXPR)) {
            return false;
        }
        RegularArgument regArg = (RegularArgument)argList.get(0);
        Name keywordArgument = regArg.keywordArgument();
        if (keywordArgument == null) {
            return true;
        }
        return Optional.ofNullable(keywordArgument.name()).filter(name -> "condition".equals(keywordArgument.name())).isPresent();
    }
}

