/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6725")
public class NumpyIsNanCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't perform an equality/inequality check against \"numpy.nan\".";
    private static final String QUICK_FIX_MESSAGE_EQUALITY = "Replace this equality check with \"numpy.isnan()\".";
    private static final String QUICK_FIX_MESSAGE_INEQUALITY = "Replace this inequality check with \"not numpy.isnan()\".";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, NumpyIsNanCheck::checkForIsNan);
    }

    private static void checkForIsNan(SubscriptionContext ctx) {
        BinaryExpression be = (BinaryExpression)ctx.syntaxNode();
        String value = be.operator().value();
        if (!"==".equals(value) && !"!=".equals(value)) {
            return;
        }
        NumpyIsNanCheck.checkOperand(ctx, be.leftOperand(), be.rightOperand(), be);
        NumpyIsNanCheck.checkOperand(ctx, be.rightOperand(), be.leftOperand(), be);
    }

    private static void checkOperand(SubscriptionContext ctx, Expression operand, Expression otherOperand, BinaryExpression be) {
        TreeUtils.getSymbolFromTree(operand).map(Symbol::fullyQualifiedName).filter("numpy.nan"::equals).ifPresent(fqn -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue(be, MESSAGE);
            NumpyIsNanCheck.addQuickFix(issue, operand, otherOperand, be);
        });
    }

    private static void addQuickFix(PythonCheck.PreciseIssue issue, Expression nanOperand, Expression otherOperand, BinaryExpression be) {
        Optional.of(nanOperand).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).map(QualifiedExpression::qualifier).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class)).map(Name::name).map(symbName -> NumpyIsNanCheck.addPrefix(be) + symbName + ".isnan(" + TreeUtils.treeToString(otherOperand, true) + ")").ifPresent(replacement -> issue.addQuickFix(PythonQuickFix.newQuickFix(NumpyIsNanCheck.operatorToMessage(be)).addTextEdit(TextEditUtils.replace(be, replacement)).build()));
    }

    private static String addPrefix(BinaryExpression be) {
        if ("==".equals(be.operator().value())) {
            return "";
        }
        return "not ";
    }

    private static String operatorToMessage(BinaryExpression be) {
        if ("==".equals(be.operator().value())) {
            return QUICK_FIX_MESSAGE_EQUALITY;
        }
        return QUICK_FIX_MESSAGE_INEQUALITY;
    }
}

