/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.nosonar.NoSonarInfoParser;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;

@Rule(key="S7632")
public class NoSonarCommentFormatCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Fix the syntax of this issue suppression comment.";
    private final NoSonarInfoParser parser = new NoSonarInfoParser();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                if (!this.parser.isInvalidIssueSuppressionComment(trivia.token().value())) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
        });
    }
}

