/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.metrics.FileLinesVisitor;

@Rule(key="NoSonar")
public class NoSonarCommentCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Is #NOSONAR used to exclude false-positive or to hide real quality flaw?";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                if (!FileLinesVisitor.containsNoSonarComment(trivia)) continue;
                ctx.addIssue(trivia.token(), MESSAGE);
            }
        });
    }
}

